# MA0101 - String contains an implicit end of line character

When using a verbatim string `@""` that contains a new line, the end of line may depend on the user's configuration (`\n` or `\r\n`).
Also, some tools such as git can change the end of line from `\n` to `\r\n` or `\r\n` to `\n`.

This means the compilation may not be deterministic.

````csharp
_ = @"test";              // valid
_ = @"line1\n" + "line2"; // valid
_ = @"line1
line 2";                  // not valid
````
