# MA0100 - Await task before disposing of resources

The rule detects `Task`, `Task<T>`, `ValueTask`, `ValueTask<T>`, or any type that follows the awaitable pattern.

````csharp
using System;
using System.Threading.Tasks;

class TestClass
{
    Task Demo1()
    {
        using var scope = new Disposable();
        return Task.Delay(1); // MA0100, you must await the task before disposing the scope
    }

    async Task Demo2()
    {
        using var scope = new Disposable();
        return await Task.Delay(1); // ok
    }
}
````
