# MA0097 - A class that implements IComparable\<T\> or IComparable should override comparison operators

````c#
class Test : IComparable<T> // non-compliant
{
    public int CompareTo(Test other) => throw null;
}

class Test : IComparable<T> // ok
{
    public int CompareTo(Test other) => throw null;
    public static bool operator <(Test a, Test b) => throw null;
    public static bool operator <=(Test a, Test b) => throw null;
    public static bool operator >(Test a, Test b) => throw null;
    public static bool operator >=(Test a, Test b) => throw null;
    public static bool operator ==(Test a, Test b) => throw null;
    public static bool operator !=(Test a, Test b) => throw null;
}
````
