# MA0080 - Use a cancellation token using .WithCancellation()

````c#
IAsyncEnumeration<string> enumerable;
await foreach (var item in enumerable) // not compliant
{
}

await foreach (var item in enumerable.WithCancellation(cancellationToken)) // compliant
{
}
````

## Additional resources

- [Enforcing asynchronous code good practices using a Roslyn analyzer](https://www.meziantou.net/enforcing-asynchronous-code-good-practices-using-a-roslyn-analyzer.htm)
