# MA0079 - Forward the CancellationToken using .WithCancellation()

````c#
CancellationToken cancellationToken;
IAsyncEnumeration<string> enumerable;
await foreach (var item in enumerable) // not compliant
{
}

await foreach (var item in enumerable.WithCancellation(cancellationToken)) // compliant
{
}
````

This rule only reports diagnostics when the calling method returns a `Task` or a `ValueTask`. [MA0080](MA0080.md) detects the same cases, but reports them even if applying a fix would require you to change the calling method's signature.

## Additional resources

- [Enforcing asynchronous code good practices using a Roslyn analyzer](https://www.meziantou.net/enforcing-asynchronous-code-good-practices-using-a-roslyn-analyzer.htm)
- [Detect missing CancellationToken using a Roslyn Analyzer](https://www.meziantou.net/detect-missing-cancellationtoken-using-a-roslyn-analyzer.htm)
