# MA0078 - Use 'Cast' instead of 'Select' to cast

## Non-compliant code

```csharp
System.Linq.Enumerable<string> strings = GetStrings();
var stringsAsObjects = strings.Select(str => (object)str);
```

## Compliant code

```csharp
System.Linq.Enumerable<string> strings = GetStrings();
var stringsAsObjects = strings.Cast<object>(str);
```
