# MA0076 - Do not use implicit culture-sensitive ToString in interpolated strings

````csharp
_ = $"abc{-1}"; // non-compliant as the result depends on the current culture

_ = FormattableString.Invariant($"abc{-1}"); // compliant but will generate MA0111
_ = string.Create(CultureInfo.InvariantCulture, $"abc{-1}"); // compliant
FormattableString str = $"abc{-1}"; // compliant
````

## Configuration

````
# Exclude ToString methods from analysis
MA0076.exclude_tostring_methods=true

# Report Nullable<T>.ToString when T is culture-sensitive
MA0076.consider_nullable_types=true
````
