# MA0075 - Do not use implicit culture-sensitive ToString

This rule reports cases where an implicit call to `obj.ToString()` may differ based on the current culture:

````csharp
_ = "abc" + -1; // non-compliant as the result depends on the current culture
_ = "abc" + 1; // compliant

_ = "abc" + -1.ToString(CultureInfo.CurrentCulture);   // compliant
_ = "abc" + -1.ToString(CultureInfo.InvariantCulture); // compliant
````

A given type is considered to have a culture-sensitive `ToString()` implementation if it implements `System.IFormattable`.<br/>
An exception is made for the following types:
* Any enum
* System.Byte
* System.Char
* System.Guid
* System.TimeSpan
* System.Version
* System.UInt16
* System.UInt32
* System.UInt64
* System.Windows.FontStretch
* System.Windows.Media.Brush

In case of the following types, MA0075 is not reported when the operand is a positive (>= 0) constant:

* System.Int16
* System.Int32
* System.Int64
* System.IntPtr
* System.SByte

## Configuration

````
# Exclude ToString methods from analysis
MA0075.exclude_tostring_methods=true

# Report Nullable<T>.ToString when T is culture-sensitive
MA0075.consider_nullable_types=true
````
