# MA0074 - Avoid implicit culture-sensitive methods

String manipulation methods in .NET do not all use the same default rules for string comparison by culture and case. For instance, `string.Equals(string, string)` uses `StringComparison.Ordinal` whereas `IndexOf(String)` uses `StringComparison.CurrentCulture`. So, you should use an overload that does not rely on default behavior.

MA0074 only reports a diagnostic when the default comparison for the method is not `Ordinal` and not `OrdinalIgnoreCase`. [`MA0001`](./MA0001.md) reports all others cases.

````csharp
"a".StartsWith("b"); // non-compliant as the default comparison of StartsWith is CurrentCulture

// Should be
"a".StartsWith("b", StringComparison.Ordinal);
````

## Additional resources

- [Best practices for comparing strings in .NET](https://learn.microsoft.com/en-us/dotnet/standard/base-types/best-practices-strings?WT.mc_id=DT-MVP-5003978#specifying-string-comparisons-explicitly)
- [String comparisons are harder than it seems](https://www.meziantou.net/string-comparisons-are-harder-than-it-seems.htm)
