# MA0071 - Avoid using redundant else

When an `if` block contains a jump statement (`break`, `continue`, `goto`, `return`, `throw`, `yield break`), using an `else` block is redundant and needlessly maintains a higher nesting level.

The rule helps reduce overall nesting, as well as the total number of lines. Refer to [Computer Programming/Coding Style/Minimize nesting](https://en.wikibooks.org/wiki/Computer_Programming/Coding_Style/Minimize_nesting).

## Non-compliant code

```csharp
if (i < 0)
{
    return -1;
}
else
{
    if (i == 0)
    {
        return 0;
    }
    else
    {
        return 1;
    }
}
```

## Compliant code

```csharp
if (i < 0)
{
    return -1;
}

if (i == 0)
{
    return 0;
}

return 1;
```
