# MA0062 - Non-flags enums should not be marked with "FlagsAttribute"

An enumeration marked with `FlagsAttribute` should only contain members whose values are powers of two or a combination of such members.

````csharp
[Flags] // Non-compliant, as 'Orange' is neither a power of two, nor a bitwise combination of existing "power of two" members
public enum Color
{
    None    = 0,
    Red     = 1,
    Orange  = 3,
    Yellow  = 4,
}
````

# Configuration

In the following case, `All` is not a power of 2 and not a combination of other values. However, this construct can be used to easily defined a value that contains all other flags.

````
[Flags]
public enum MyEnum
{
    None    = 0,
    Option1 = 1,
    All     = ~None,
}
````

You can allow this pattern by adding the following configuration to the `.editorconfig` file:

````
MA0062.allow_all_bits_set_value = true
````
