# MA0061 - Method overrides should not change default values

Default arguments used in a call are determined by the static type of the object. If a default argument is different in an overriding method, the value used will be different when calls are made via the base or derived types, which may be contrary to developers' expectations.

Moreover, default argument values are useless in explicit interface implementations, because the static type of the object will always be the implemented interface. Thus, specifying default values is useless and confusing.

````csharp
public class Foo
{
  public virtual void Write(int i = 42)
  {
    Console.WriteLine(i);
  }
}

public class Bar : Foo
{
  public override void Write(int i = 5) // Noncompliant
  {
    Console.WriteLine(i);
  }
}
````
