# MA0060 - The value returned by Stream.Read/Stream.ReadAsync is not used

You should use the value of `Stream.Read` to know how many bytes were actually read. This can be less than the number of bytes requested, if that many bytes are not currently available, or zero if the end of the stream was reached.

````csharp
class Test
{
    void A()
    {
        var stream = File.OpenRead("file.txt");
        var bytes = new byte[10];
        stream.Read(bytes, 0, bytes.Length); // Non-compliant

        var read = stream.Read(bytes, 0, bytes.Length); // ok
        var data = bytes.AsSpan(0, read);
    }
}
````
