# MA0056 - Do not call overridable members in constructor

When a virtual method is called, the actual type that executes the method is not selected until run time. When a constructor calls a virtual method, it's possible that the constructor for the actual instance type has not been executed yet.

````csharp
class Sample
{
    public Sample()
    {
        // What does it do?
        // new Sample2() prints "0"
        VirtualMethod(); // Non compliant
    }

    protected virtual void VirtualMethod()
    {
    }
}

class Sample2 : Sample
{
    private int value;

    public Sample2() => value = 42;

    protected override void VirtualMethod()
    {
        Console.WriteLine(value);
    }
}
````

The diagnostic is not reported in `sealed` classes.
