# MA0055 - Do not use finalizer

Finalizers should be used to ensure native resources are released. Since .NET 2.0, you should better encapsulate the native resources into a SafeHandle.

- [Stop using IntPtr for dealing with system handles](https://www.meziantou.net/2019/05/13/stop-using-intptr-for-dealing-with-system-handles)
- [Finalizers (C# Programming Guide)](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/finalizers?WT.mc_id=DT-MVP-5003978)
- [CA1063: Implement IDisposable correctly](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1063?WT.mc_id=DT-MVP-5003978)

````csharp
class Sample
{
    ~Sample() // Non compliant
    {
    }
}
````
