# MA0053 - Make class sealed

Classes should be sealed when there is no inheritor.

- [Why Are So Many Of The Framework Classes Sealed?](https://blogs.msdn.microsoft.com/ericlippert/2004/01/22/why-are-so-many-of-the-framework-classes-sealed/)
- [Performance benefits of sealed class in .NET](https://www.meziantou.net/performance-benefits-of-sealed-class.htm)
- [Do sealed classes really offer performance Benefits?](https://stackoverflow.com/a/2183/2996339)

````csharp
public class Foo // compliant
{
}

public class Bar : Foo // Non compliant
{
}

// Should be
public sealed class Bar : Foo
{
}
````

# Configuration

A Roslyn analyzer can only know the current project context, not the full solution.
Therefore it cannot know if a public class is used in another project hereby making it possibly inaccurate to report this diagnostic for `public` classes.
You can still enable this rule for `public` classes using the `.editorconfig`:

````
# .editorconfig file
MA0053.public_class_should_be_sealed = true
````

Classes with `virtual` members cannot be sealed. By default, these classes are not reported. You can enable this rule for classes with `virtual` members using the `.editorconfig`:

````
# .editorconfig file
MA0053.class_with_virtual_member_should_be_sealed = true
````

Classes that inherits from `Exception`are not reported by default. You can enable the analyzer for these classes using the `.editorconfig`:

````
# .editorconfig file
MA0053.exceptions_should_be_sealed = true
````
