# MA0050 - Validate arguments correctly in iterator methods

When a method contains a `yield` statement, the evaluation of the method is deferred until the first enumeration. This rule ensures that arguments are validated immediately, while execution of the rest of the method is still deferred.

````csharp
IEnumerable<int> Sample(string a)
{
    if (a == null)
        throw new System.ArgumentNullException(nameof(a));

    yield return 0;
}
````

Should be

````csharp
IEnumerable<int> Sample(string a)
{
    if (a == null)
        throw new System.ArgumentNullException(nameof(a));

    return Sample();

    IEnumerable<int> Sample()
    {
        yield return 0;
    }
}
````
