# MA0048 - File name must match type name

The name of the class must match to name of the file. This rule has two main reasons:
- Ensuring the type name is the same as the file name. This prevents renaming a type without renaming the file.
- When you navigate in the code without an IDE, such as GitHub, GitLab or most web interfaces, you can quickly find the file that you are insterested in.

````csharp
// filename: Bar.cs
class Foo // non compliant
{
}

// filename: Foo.cs
class Foo // compliant
{
}

// filename: Foo.cs
class Foo<T> // compliant
{
}

// filename: Foo`1.cs
class Foo<T> // compliant
{
}

// filename: FooOfT.cs
class Foo<T> // compliant
{
}

// filename: Foo{TKey,TResult}.cs
class Foo<TKey, TResult> // compliant
{
}

// filename: Foo{T}.cs
class Foo<TKey, TResult> // non compliant
{
}
````

If a file contains multiple types, you can disable the rule locally by using `#pragma warning disable MA0048` or `[SuppressMessage]`

````csharp
public class MatchFileName {}

[System.Diagnostics.CodeAnalysis.SuppressMessage("Design", "MA0048:File name must match type name", Justification = "<Pending>")]
public class DoNotMatchFileName1 { }

#pragma warning disable MA0048
public class DoNotMatchFileName2 { }
public class DoNotMatchFileName3 { }
````

# Configuration

````
# .editorconfig file
# Exclude "file class Sample" from analysis. default: true
MA0048.exclude_file_local_types = true

# Only validate the first type in a file. default: false
MA0048.only_validate_first_type = false

# Ignore certain symbols. default: none
# Pipe-separated list of wildcard patterns
dotnet_diagnostic.MA0048.excluded_symbol_names = Foo*|T:MyNamespace.Bar
````
