# MA0045 - Do not use blocking calls in a sync method (need to make calling method async)

You should replace blocking calls, such as `Wait` or `Result`, with an async call using `await`. The calling method will need to become `async`.

> **Note**
> This rule is useful to transform synchronous code to asynchronous code.

````csharp
public void Sample()
{
    Thread.Sleep(1); // Non compliant
    Task.Delay(1).Wait(); // non compliant

    var result = Task.Run(() => 10).Result; // non compliant
}
````

Should be

````csharp
public async Task Sample()
{
    await Task.Delay(1);
    await Task.Delay(1);

    var result = await Task.Run(() => 10);
}
````

## Additional resources

- [Enforcing asynchronous code good practices using a Roslyn analyzer](https://www.meziantou.net/enforcing-asynchronous-code-good-practices-using-a-roslyn-analyzer.htm)
