# MA0043 - Use nameof operator in ArgumentException

When throwing an `ArgumentException`, you should use the `nameof` operator to specify the argument name.

````csharp
void Sample(string s)
{
    if (s == null)
        throw new ArgumentNullException("s"); // non compliant
}
````

````csharp
void Sample(string s)
{
    if (s == null)
        throw new ArgumentNullException(nameof(s)); // compliant
}
````
