# MA0042 - Do not use blocking calls in an async method

You should replace blocking calls, such as `Wait` or `Result`, with an async call using `await`.

````csharp
public async Task Sample()
{
    Thread.Sleep(1); // Non compliant
    Task.Delay(1).Wait(); // non compliant
    await Task.Delay(1); // compliant

    var result = Task.Run(() => 10).Result; // non compliant
    var result = await Task.Run(() => 10); // compliant
}
````

The rule only reports a diagnostic when the enclosing method is already `async` or when the `async` keyword can be added with changing the return type. While you can use `async void`, the rule will not report a diagnostic when the method returns `void`. [MA0045](MA0045.md) detects the same cases, but reports them even if applying a fix would require you to change the calling method's signature.

````csharp
public Task Sample()
{
    Thread.Sleep(1); // Non compliant, as you can add "async" to the signature without changing the return type
}

public int Sample()
{
    Thread.Sleep(1); // compliant, as you cannot add "async" to the signature without changing the return type
    return 0;
}
````


## Additional resources

- [Enforcing asynchronous code good practices using a Roslyn analyzer](https://www.meziantou.net/enforcing-asynchronous-code-good-practices-using-a-roslyn-analyzer.htm)
