# MA0040 - Forward the CancellationToken parameter to methods that take one

If there is a `CancellationToken` in scope, it should be passed along when calling a method that supports it.

````csharp
class Test
{
    public void A(CancellationToken cancellationToken)
    {
        MethodWithCancellationToken(); // non compliant
        MethodWithCancellationToken(cancellationToken); // compliant
    }

    public void MethodWithCancellationToken() => throw null;
    public void MethodWithCancellationToken(System.Threading.CancellationToken cancellationToken) => throw null;
}
````

This rule only reports a diagnostic when a `CancellationToken` is available in the scope. [MA0032](MA0032.md) detects the same cases, but reports them even if applying a fix would require you to change the calling method's signature.

## Configuration

````
MA0032.allowOverloadsWithOptionalParameters = false
````

````c#
Foo.Bar(); // report when MA0032.allowOverloadsWithOptionalParameters is true

class Foo
{
    public static void Bar() => throw null;
    public static void Bar(CancellationToken cancellationToken, bool dummy = false) => throw null;
}
````

## Additional resources

- [Enforcing asynchronous code good practices using a Roslyn analyzer](https://www.meziantou.net/enforcing-asynchronous-code-good-practices-using-a-roslyn-analyzer.htm)
- [Detect missing CancellationToken using a Roslyn Analyzer](https://www.meziantou.net/detect-missing-cancellationtoken-using-a-roslyn-analyzer.htm)
