# MA0032 - Use an overload with a CancellationToken argument

You should pass a `CancellationToken` when calling a method if there is an overload of the method that supports it.

````csharp
class Test
{
    public void A(CancellationToken cancellationToken)
    {
        MethodWithCancellationToken(); // non compliant
        MethodWithCancellationToken(cancellationToken); // compliant
    }

    public void MethodWithCancellationToken() => throw null;
    public void MethodWithCancellationToken(System.Threading.CancellationToken cancellationToken) => throw null;
}
````

## Configuration

````
MA0032.allowOverloadsWithOptionalParameters = false
````

````c#
Foo.Bar(); // report when MA0032.allowOverloadsWithOptionalParameters is true

class Foo
{
    public static void Bar() => throw null;
    public static void Bar(CancellationToken cancellationToken, bool dummy = false) => throw null;
}
````

## Additional resources

- [Enforcing asynchronous code good practices using a Roslyn analyzer](https://www.meziantou.net/enforcing-asynchronous-code-good-practices-using-a-roslyn-analyzer.htm)
