# MA0024 - Use an explicit StringComparer when possible

You should use an explicit comparer for string.

````csharp
EqualityComparer<string>.Default.Equals("a", "b");

// Should be
StringComparer.Ordinal.Equals("a", "b");
````

## Additional resources

- [Best practices for comparing strings in .NET](https://learn.microsoft.com/en-us/dotnet/standard/base-types/best-practices-strings?WT.mc_id=DT-MVP-5003978#specifying-string-comparisons-explicitly)
- [String comparisons are harder than it seems](https://www.meziantou.net/string-comparisons-are-harder-than-it-seems.htm)
