# MA0016 - Prefer using collection abstraction instead of implementation

Methods and properties visible to other assemblies (`public` or `protected`) should use collection interfaces instead of collection implementations.

````c#
public List<string> Prop { get; set; } // non-compliant
public IList<string> Prop { get; set; } // ok

public void Method(Dictionary<string, string> arg) {} // non-compliant
````

The analyzer detects `List<T>`, `HashSet<T>`, `Dictionary<TKey,TValue>`, and `System.Collections.ObjectModel.Collection<T>`. The rule is disabled if the property is decorated with an XML serialization attribute.
