# MA0011 - IFormatProvider is missing

This rule warns about the usage of overloads of methods like `Parse`, `TryParse` and `ToString` that do not take a parameter of type `IFormatProvider`.

More information on Creating Globally Aware Applications here: [Creating Globally Aware Applications](https://learn.microsoft.com/en-us/previous-versions/windows/silverlight/dotnet-windows-silverlight/cc853414(v=vs.95)?WT.mc_id=DT-MVP-5003978)

````csharp
DateTime.TryParse("", out var result);

// Should be
DateTime.TryParse("", CultureInfo.InvariantCulture, DateTimeStyles.None, out var result);
````

````csharp
DateTime dt;

dt.ToString();    // non-compliant
dt.ToString("o"); // ok as "o" is a culture invariant format
````

````csharp
DateTime? dt;

dt.ToString(); // non-compliant
dt?.ToString(CultureInfo.CurrentCulture); // ok
dt?.ToString("o"); // ok as "o" is a culture invariant format
````

## Configuration

````
# Exclude ToString methods from analysis
MA0011.exclude_tostring_methods=true

# Report Nullable<T>.ToString when T is culture-sensitive
MA0011.consider_nullable_types=true
````
