# MA0010 - Mark attributes with AttributeUsageAttribute

When you define a custom attribute, mark it with `[AttributeUsage]` to indicate where in the source code the custom attribute can be applied.

````c#
// non-compliant
class SampleAttribute : System.Attribute { }

// ok
[System.AttributeUsage(System.AttributeTargets.Parameter)]
class SampleAttribute : System.Attribute { }
````
