# MA0009 - Add regex evaluation timeout

````csharp
new Regex(""); // not compliant
new Regex("", RegexOptions.None); // notcompliant

new Regex("", RegexOptions.None, TimeSpan.FromSeconds(1)); // ok

[GeneratedRegex(""pattern"", RegexOptions.None)] // not compliant
private static partial Regex Test();

[GeneratedRegex(""pattern"", RegexOptions.None, matchTimeoutMilliseconds: 1000)] // ok compliant
private static partial Regex Test();
````


More information: [Regex - Deny of Service (ReDoS)](https://www.meziantou.net/regex-deny-of-service-redos.htm)
