# MA0008 - Add StructLayoutAttribute

The rule reports `struct`s where
- There are at least 2 fields
- All fields are [blittable](https://learn.microsoft.com/en-us/dotnet/framework/interop/blittable-and-non-blittable-types?WT.mc_id=DT-MVP-5003978)
- The struct is not decorated with `[StructLayout]`

````c#
struct A { } // ok
struct A { public int A; } // ok as the struct single blittable type
struct A { public int A; public string B } // ok as the struct contains a not blittable field

struct A { public int A; public int B; } // report diagnostic as both fields are blittable
````

````csharp
struct Sample
{
    public int A;
    public int B;
}

// Should be
[StructLayout(LayoutKind.XXX)]
struct Sample
{
    public int A;
    public int B;
}
````

More information: [Optimize struct performances using StructLayout](https://www.meziantou.net/optimize-struct-performances-using-structlayout.htm)
