# MA0006 - Use String.Equals instead of equality operator

You should use `string.Equals` instead of `==` or `!=`, to make string comparison rules explicit.

````csharp
"" == "";

// Should be
string.Equals("", "", StringComparison.Ordinal);
````

````csharp
"" != "";

// Should be
!string.Equals("", "", StringComparison.Ordinal);
````

## Additional resources

- [Best practices for comparing strings in .NET](https://learn.microsoft.com/en-us/dotnet/standard/base-types/best-practices-strings?WT.mc_id=DT-MVP-5003978#specifying-string-comparisons-explicitly)
- [String comparisons are harder than it seems](https://www.meziantou.net/string-comparisons-are-harder-than-it-seems.htm)
