# MA0004 - Use Task.ConfigureAwait

- If the `SynchronizationContext` is not needed, you should use `ConfigureAwait(false)`
- If the `SynchronizationContext` is needed (WinForm, WPF, ASP.NET, Blazor, etc.), you can use `ConfigureAwait(true)` or `ConfigureAwait(ConfigureAwaitOptions.ContinueOnCapturedContext)` to make it explicit, or you can disable the rule locally

````csharp
await task;

// Should be
await task.ConfigureAwait(false);
// or
await task.ConfigureAwait(true);
````

## Configuration (`.editorconfig`)

````
[.*cs]
MA0004.report = DetectContext # (default) Try to detect the current context and report only if it considers ConfigureAwait is needed
MA0004.report = Always        # Always report missing ConfigureAwait whatever the context
````

## Additional resources

- [Enforcing asynchronous code good practices using a Roslyn analyzer](https://www.meziantou.net/enforcing-asynchronous-code-good-practices-using-a-roslyn-analyzer.htm)
