# MA0003 - Add parameter name to improve readability

You should name the parameter when you call a method with a literal value

- `null`
- `true`
- `false`
- `"abc"`
- `42`

````csharp
obj.Test(null);

// Should be
obj.Test(name: null);
````

# Configuration (`.editorconfig`)

````
[.*cs]
MA0003.minimum_method_parameters = 1 # Only consider methods with 1 or more parameters
MA0003.expression_kinds = Null, Boolean, Numeric, String  # Default: Null | Boolean

# '|'-separated values of documentation comments https://github.com/dotnet/csharplang/blob/main/spec/documentation-comments.md#id-string-format
MA0003.excluded_methods = M:A.B(System.Int32) | M:C.D()

# The regex matches the documention comment of the method (https://github.com/dotnet/csharplang/blob/main/spec/documentation-comments.md#id-string-format)
MA0003.excluded_methods_regex = Sample.*Test
````

You can annotate a parameter with `Meziantou.Analyzer.Annotations.RequireNamedArgumentAttribute`. This attribute is available using the
`Meziantou.Analyzer.Annotations` NuGet package.

```c#
Test("test"); // report a diagnostic as the parameter is not named

// Requires Meziantou.Analyzer.Annotations package
public void Test([RequireNamedArgument] string value) { }
```
