# MA0002 - IEqualityComparer\<string\> or IComparer\<string\> is missing

You should be explicit in the way strings ought to be compared in `HashSet<string>`, `Dictionary<string, TValue>`, `ConcurrentDictionary<string, TValue>` or any methods that compare strings.

````csharp
new HashSet<string>()

// Should be
new HashSet<string>(StringComparer.Ordinal)
````

````csharp
new Dictionary<string, int>()

// Should be
new Dictionary<string, int>(StringComparer.Ordinal)
````

````csharp
new ConcurrentDictionary<string, int>()

// Should be
new ConcurrentDictionary<string, int>(StringComparer.Ordinal)
````

````csharp
IEnumerable<string> list;
list.Distinct();

// Should be
list.Distinct(StringComparer.Ordinal);
````

# Configuration

The rule can be configured using an `.editorconfig` file:

```
# Exclude the rules from code generated by query operators (e.g. from item in collection orderby item select item)
MA0002.exclude_query_operator_syntaxes = false
```

## Additional resources

- [Best practices for comparing strings in .NET](https://learn.microsoft.com/en-us/dotnet/standard/base-types/best-practices-strings?WT.mc_id=DT-MVP-5003978#specifying-string-comparisons-explicitly)
- [String comparisons are harder than it seems](https://www.meziantou.net/string-comparisons-are-harder-than-it-seems.htm)
