# Voice-Omni

- [**mini-omni**](https://github.com/gpt-omni/mini-omni) - gpt-omni ![Star](https://img.shields.io/github/stars/gpt-omni/mini-omni.svg?style=social&label=Star)

	 *open-source multimodal large language model that can hear, talk while thinking. Featuring real-time end-to-end speech input and streaming audio output conversational capabilities.*

## Survey
- **Recent Advances in Speech Language Models: A Survey**, `arXiv, 2410.03751`, [arxiv](http://arxiv.org/abs/2410.03751v1), [pdf](http://arxiv.org/pdf/2410.03751v1.pdf), cication: [**-1**](None)

	 *Wenqian Cui, Dianzhi Yu, Xiaoqi Jiao, Ziqiao Meng, Guangyan Zhang, Qichao Wang, Yiwen Guo, Irwin King*

## Papers
- [[2406.12428] PSLM: Parallel Generation of Text and Speech with LLMs for Low-Latency Spoken Dialogue Systems](https://arxiv.org/abs/2406.12428)
	- [PSLM](https://rinnakk.github.io/research/publications/PSLM)
- **Baichuan-Omni Technical Report**, `arXiv, 2410.08565`, [arxiv](http://arxiv.org/abs/2410.08565v1), [pdf](http://arxiv.org/pdf/2410.08565v1.pdf), cication: [**-1**](None)

	 *Yadong Li, Haoze Sun, Mingan Lin, Tianpeng Li, Guosheng Dong, Tao Zhang, Bowen Ding, Wei Song, Zhenglin Cheng, Yuqi Huo* · ([bc-omni](https://github.com/westlake-baichuan-mllm/bc-omni) - westlake-baichuan-mllm) ![Star](https://img.shields.io/github/stars/westlake-baichuan-mllm/bc-omni.svg?style=social&label=Star)
- **IntrinsicVoice: Empowering LLMs with Intrinsic Real-time Voice
  Interaction Abilities**, `arXiv, 2410.08035`, [arxiv](http://arxiv.org/abs/2410.08035v1), [pdf](http://arxiv.org/pdf/2410.08035v1.pdf), cication: [**-1**](None)

	 *Xin Zhang, Xiang Lyu, Zhihao Du, Qian Chen, Dong Zhang, Hangrui Hu, Chaohong Tan, Tianyu Zhao, Yuxuan Wang, Bin Zhang*
- **Distilling an End-to-End Voice Assistant Without Instruction Training
  Data**, `arXiv, 2410.02678`, [arxiv](http://arxiv.org/abs/2410.02678v1), [pdf](http://arxiv.org/pdf/2410.02678v1.pdf), cication: [**-1**](None)

	 *William Held, Ella Li, Michael Ryan, Weiyan Shi, Yanzhe Zhang, Diyi Yang* · ([levanter](https://github.com/Helw150/levanter/blob/will/distill/src/levanter/models/via.py) - Helw150) ![Star](https://img.shields.io/github/stars/Helw150/levanter.svg?style=social&label=Star)
- **MIO: A Foundation Model on Multimodal Tokens**, `arXiv, 2409.17692`, [arxiv](http://arxiv.org/abs/2409.17692v1), [pdf](http://arxiv.org/pdf/2409.17692v1.pdf), cication: [**-1**](None)

	 *Zekun Wang, King Zhu, Chunpu Xu, Wangchunshu Zhou, Jiaheng Liu, Yibo Zhang, Jiashuo Wang, Ning Shi, Siyu Li, Yizhi Li*
- **EMOVA: Empowering Language Models to See, Hear and Speak with Vivid
  Emotions**, `arXiv, 2409.18042`, [arxiv](http://arxiv.org/abs/2409.18042v1), [pdf](http://arxiv.org/pdf/2409.18042v1.pdf), cication: [**-1**](None)

	 *Kai Chen, Yunhao Gou, Runhui Huang, Zhili Liu, Daxin Tan, Jing Xu, Chunwei Wang, Yi Zhu, Yihan Zeng, Kuo Yang* · ([emova-ollm.github](https://emova-ollm.github.io/))
- [Tincans - Final Technical Report](https://tincans.ai/report)
- [**moshi**](https://github.com/kyutai-labs/moshi) - kyutai-labs ![Star](https://img.shields.io/github/stars/kyutai-labs/moshi.svg?style=social&label=Star)

	 · ([kyutai](https://kyutai.org/Moshi.pdf)) · ([huggingface](https://huggingface.co/collections/kyutai/moshi-v01-release-66eaeaf3302bef6bd9ad7acd))
- **LLaMA-Omni: Seamless Speech Interaction with Large Language Models**, `arXiv, 2409.06666`, [arxiv](http://arxiv.org/abs/2409.06666v1), [pdf](http://arxiv.org/pdf/2409.06666v1.pdf), cication: [**-1**](None)

	 *Qingkai Fang, Shoutao Guo, Yan Zhou, Zhengrui Ma, Shaolei Zhang, Yang Feng* · ([LLaMA-Omni](https://github.com/ictnlp/LLaMA-Omni) - ictnlp) ![Star](https://img.shields.io/github/stars/ictnlp/LLaMA-Omni.svg?style=social&label=Star)
- **Body of Her: A Preliminary Study on End-to-End Humanoid Agent**, `arXiv, 2408.02879`, [arxiv](http://arxiv.org/abs/2408.02879v1), [pdf](http://arxiv.org/pdf/2408.02879v1.pdf), cication: [**-1**](None)

	 *Tenglong Ao*

	 · ([aubrey-ao.github](https://aubrey-ao.github.io/BodyOfHer))
- **VITA: Towards Open-Source Interactive Omni Multimodal LLM**, `arXiv, 2408.05211`, [arxiv](http://arxiv.org/abs/2408.05211v1), [pdf](http://arxiv.org/pdf/2408.05211v1.pdf), cication: [**-1**](None)

	 *Chaoyou Fu, Haojia Lin, Zuwei Long, Yunhang Shen, Meng Zhao, Yifan Zhang, Xiong Wang, Di Yin, Long Ma, Xiawu Zheng* · ([vita-home.github](https://vita-home.github.io/)) · ([VITA](https://github.com/VITA-MLLM/VITA) - VITA-MLLM) ![Star](https://img.shields.io/github/stars/VITA-MLLM/VITA.svg?style=social&label=Star)
- **Language Model Can Listen While Speaking**, `arXiv, 2408.02622`, [arxiv](http://arxiv.org/abs/2408.02622v1), [pdf](http://arxiv.org/pdf/2408.02622v1.pdf), cication: [**-1**](None)

	 *Ziyang Ma, Yakun Song, Chenpeng Du, Jian Cong, Zhuo Chen, Yuping Wang, Yuxuan Wang, Xie Chen* · ([ddlbojack.github](https://ddlbojack.github.io/LSLM))
- **Talk With Human-like Agents: Empathetic Dialogue Through Perceptible
  Acoustic Reception and Reaction**, `arXiv, 2406.12707`, [arxiv](http://arxiv.org/abs/2406.12707v1), [pdf](http://arxiv.org/pdf/2406.12707v1.pdf), cication: [**-1**](None)

	 *Haoqiu Yan, Yongxin Zhu, Kai Zheng, Bing Liu, Haoyu Cao, Deqiang Jiang, Linli Xu* · ([PerceptiveAgent](https://github.com/Haoqiu-Yan/PerceptiveAgent) - Haoqiu-Yan) ![Star](https://img.shields.io/github/stars/Haoqiu-Yan/PerceptiveAgent.svg?style=social&label=Star)
- **SpiRit-LM: Interleaved Spoken and Written Language Model**, `arXiv, 2402.05755`, [arxiv](http://arxiv.org/abs/2402.05755v1), [pdf](http://arxiv.org/pdf/2402.05755v1.pdf), cication: [**2**](https://scholar.google.com/scholar?cites=7368374930715826231&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Tu Anh Nguyen, Benjamin Muller, Bokai Yu, Marta R. Costa-jussa, Maha Elbayad, Sravya Popuri, Paul-Ambroise Duquenne, Robin Algayres, Ruslan Mavlyutov, Itai Gat*

	 · ([speechbot.github](https://speechbot.github.io/spiritlm/index.html))
- **Speak While You Think: Streaming Speech Synthesis During Text Generation**, `icassp 2024-2024 ieee international conference on acoustics …, 2024`, [arxiv](http://arxiv.org/abs/2309.11210v1), [pdf](http://arxiv.org/pdf/2309.11210v1.pdf), cication: [**1**](https://scholar.google.com/scholar?cites=2989454037175742919&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Avihu Dekel, Slava Shechtman, Raul Fernandez, David Haws, Zvi Kons, Ron Hoory*
- **LauraGPT: Listen, Attend, Understand, and Regenerate Audio with GPT**, `arXiv, 2310.04673`, [arxiv](http://arxiv.org/abs/2310.04673v4), [pdf](http://arxiv.org/pdf/2310.04673v4.pdf), cication: [**-1**](None)

	 *Zhihao Du, Jiaming Wang, Qian Chen, Yunfei Chu, Zhifu Gao, Zerui Li, Kai Hu, Xiaohuan Zhou, Jin Xu, Ziyang Ma*
- **VioLA: Unified Codec Language Models for Speech Recognition, Synthesis,
  and Translation**, `arXiv, 2305.16107`, [arxiv](http://arxiv.org/abs/2305.16107v1), [pdf](http://arxiv.org/pdf/2305.16107v1.pdf), cication: [**-1**](None)

	 *Tianrui Wang, Long Zhou, Ziqiang Zhang, Yu Wu, Shujie Liu, Yashesh Gaur, Zhuo Chen, Jinyu Li, Furu Wei*
- **Spoken Question Answering and Speech Continuation Using
  Spectrogram-Powered LLM**, `arXiv, 2305.15255`, [arxiv](http://arxiv.org/abs/2305.15255v4), [pdf](http://arxiv.org/pdf/2305.15255v4.pdf), cication: [**2**](https://scholar.google.com/scholar?cites=2239314690427158927&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Eliya Nachmani, Alon Levkovitch, Roy Hirsch, Julian Salazar, Chulayuth Asawaroengchai, Soroosh Mariooryad, Ehud Rivlin, RJ Skerry-Ryan, Michelle Tadmor Ramanovich* · ([research](https://research.google/blog/spoken-question-answering-and-speech-continuation-using-a-spectrogram-powered-llm/)) · ([LLAMA1-Test-Set](https://github.com/google-research-datasets/LLAMA1-Test-Set) - google-research-datasets) ![Star](https://img.shields.io/github/stars/google-research-datasets/LLAMA1-Test-Set.svg?style=social&label=Star) · ([michelleramanovich.github](https://michelleramanovich.github.io/spectron/spectron))
- [[2203.16502] Generative Spoken Dialogue Language Modeling](https://arxiv.org/abs/2203.16502)
- **Text-Free Prosody-Aware Generative Spoken Language Modeling**, `arXiv, 2109.03264`, [arxiv](http://arxiv.org/abs/2109.03264v2), [pdf](http://arxiv.org/pdf/2109.03264v2.pdf), cication: [**86**](https://scholar.google.com/scholar?cites=6860409912627023988&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Eugene Kharitonov, Ann Lee, Adam Polyak, Yossi Adi, Jade Copet, Kushal Lakhotia, Tu-Anh Nguyen, Morgane Rivière, Abdelrahman Mohamed, Emmanuel Dupoux*

## Projects
- [🍓 Ichigo: Llama learns to talk - Homebrew](https://homebrew.ltd/blog/llama-learns-to-talk)

	 · ([x](https://x.com/reach_vb/status/1845749495927062861))
- [**ichigo**](https://github.com/homebrewltd/ichigo?tab=readme-ov-file) - homebrewltd ![Star](https://img.shields.io/github/stars/homebrewltd/ichigo.svg?style=social&label=Star)

	 *Llama3.1 learns to Listen*
- [**Westlake-Omni**](https://github.com/xinchen-ai/Westlake-Omni) - xinchen-ai ![Star](https://img.shields.io/github/stars/xinchen-ai/Westlake-Omni.svg?style=social&label=Star)
- [**LLaMA-Omni**](https://github.com/ictnlp/LLaMA-Omni) - ictnlp ![Star](https://img.shields.io/github/stars/ictnlp/LLaMA-Omni.svg?style=social&label=Star)

	 *Low-latency and high-quality end-to-end speech interaction model built upon Llama-3.1-8B-Instruct.*
- [**flow_mirror**](https://github.com/jingzhunxue/flow_mirror/tree/main) - jingzhunxue ![Star](https://img.shields.io/github/stars/jingzhunxue/flow_mirror.svg?style=social&label=Star)

	 *flow mirror models from JZX AI Labs*
- [Llama3 just got ears - Homebrew](https://homebrew.ltd/blog/llama3-just-got-ears)

	 · ([huggingface](https://huggingface.co/homebrewltd/Llama3.1-s-instruct-2024-08-19-epoch-3))
- [**speech-to-speech**](https://github.com/huggingface/speech-to-speech) - huggingface ![Star](https://img.shields.io/github/stars/huggingface/speech-to-speech.svg?style=social&label=Star)
- [SpeechGPT2: End-to-End Human-Like Spoken Chatbot](https://0nutation.github.io/SpeechGPT2.github.io/)
- [The Textless NLP project](https://speechbot.github.io/)
- [**Desktop_BUD-E**](https://github.com/christophschuhmann/Desktop_BUD-E/tree/main) - christophschuhmann ![Star](https://img.shields.io/github/stars/christophschuhmann/Desktop_BUD-E.svg?style=social&label=Star)

	 *This is a voice assitant to run on you laptop*
- [Call to Build Open Multi-Modal Models for Personal Assistants | LAION](https://laion.ai/notes/open-gpt-4-o/)
- [Building GPT2o — Part 1 : Audio. code, pretrained model, colab notebook | by Srinivas Billa | Jun, 2024 | Medium](https://medium.com/@nivibilla/building-gpt2o-part-1-audio-65b66e193784)

	 · ([build-nanogpt](https://github.com/nivibilla/build-nanogpt/tree/audio) - nivibilla) ![Star](https://img.shields.io/github/stars/nivibilla/build-nanogpt.svg?style=social&label=Star)
- [**natural_voice_assistant**](https://github.com/LAION-AI/natural_voice_assistant) - LAION-AI ![Star](https://img.shields.io/github/stars/LAION-AI/natural_voice_assistant.svg?style=social&label=Star)

	 · ([laion](https://laion.ai/blog/bud-e/))
- [**WhisperFusion**](https://github.com/collabora/WhisperFusion) - collabora ![Star](https://img.shields.io/github/stars/collabora/WhisperFusion.svg?style=social&label=Star)

	 *WhisperFusion builds upon the capabilities of WhisperLive and WhisperSpeech to provide a seamless conversations with an AI.*
- [**natural_voice_assistant**](https://github.com/LAION-AI/natural_voice_assistant) - LAION-AI ![Star](https://img.shields.io/github/stars/LAION-AI/natural_voice_assistant.svg?style=social&label=Star)
- [**pipecat**](https://github.com/pipecat-ai/pipecat) - pipecat-ai ![Star](https://img.shields.io/github/stars/pipecat-ai/pipecat.svg?style=social&label=Star)

	 *Open Source framework for voice and multimodal conversational AI*
- [Audio Text GPT - Google Docs](https://docs.google.com/document/d/1nfngl0lv3XAWLQg5z-euYcE6NGGaoH7BdyoujVf7tEc/edit)
- [**gazelle**](https://github.com/tincans-ai/gazelle/tree/main?tab=readme-ov-file) - tincans-ai ![Star](https://img.shields.io/github/stars/tincans-ai/gazelle.svg?style=social&label=Star)

	 *Joint speech-language model - respond directly to audio!* · ([tincans](https://tincans.ai/slm)) · ([x](https://x.com/hingeloss/status/1765440068452331898)) · ([x](https://x.com/hingeloss/status/1770157984745656743))
## Acoustic echo cancellation
- [**NKF-AEC**](https://github.com/fjiang9/NKF-AEC?tab=readme-ov-file) - fjiang9 ![Star](https://img.shields.io/github/stars/fjiang9/NKF-AEC.svg?style=social&label=Star)

	 *Acoustic Echo Cancellation with Nerual Kalman Filtering* · ([fjiang9.github](https://fjiang9.github.io/NKF-AEC/))
- [**DTLN-aec**](https://github.com/breizhn/DTLN-aec) - breizhn ![Star](https://img.shields.io/github/stars/breizhn/DTLN-aec.svg?style=social&label=Star)

	 *This Repostory contains the pretrained DTLN-aec model for real-time acoustic echo cancellation.*
- [**TSPNN**](https://github.com/enhancer12/TSPNN) - enhancer12 ![Star](https://img.shields.io/github/stars/enhancer12/TSPNN.svg?style=social&label=Star)

	 *Two-stage progressive neural network for acoustic echo cancellation*

## Duplex
- **Enabling Real-Time Conversations with Minimal Training Costs**, `arXiv, 2409.11727`, [arxiv](http://arxiv.org/abs/2409.11727v1), [pdf](http://arxiv.org/pdf/2409.11727v1.pdf), cication: [**-1**](None)

	 *Wang Xu, Shuo Wang, Weilin Zhao, Xu Han, Yukun Yan, Yudi Zhang, Zhe Tao, Zhiyuan Liu, Wanxiang Che*
- **Language Model Can Listen While Speaking**, `arXiv, 2408.02622`, [arxiv](http://arxiv.org/abs/2408.02622v1), [pdf](http://arxiv.org/pdf/2408.02622v1.pdf), cication: [**-1**](None)

	 *Ziyang Ma, Yakun Song, Chenpeng Du, Jian Cong, Zhuo Chen, Yuping Wang, Yuxuan Wang, Xie Chen* · ([LSLM-Listening-while-Speaking-Language-Model](https://github.com/sanowl/LSLM-Listening-while-Speaking-Language-Model) - sanowl) ![Star](https://img.shields.io/github/stars/sanowl/LSLM-Listening-while-Speaking-Language-Model.svg?style=social&label=Star) · ([fairseq](https://github.com/facebookresearch/fairseq/tree/main/examples/wav2vec#vq-wav2vec) - facebookresearch) ![Star](https://img.shields.io/github/stars/facebookresearch/fairseq.svg?style=social&label=Star)
- **Beyond the Turn-Based Game: Enabling Real-Time Conversations with Duplex
  Models**, `arXiv, 2406.15718`, [arxiv](http://arxiv.org/abs/2406.15718v1), [pdf](http://arxiv.org/pdf/2406.15718v1.pdf), cication: [**-1**](None)

	 *Xinrong Zhang, Yingfa Chen, Shengding Hu, Xu Han, Zihang Xu, Yuanwei Xu, Weilin Zhao, Maosong Sun, Zhiyuan Liu*
- **Modeling Real-Time Interactive Conversations as Timed Diarized
  Transcripts**, `arXiv, 2405.13203`, [arxiv](http://arxiv.org/abs/2405.13203v1), [pdf](http://arxiv.org/pdf/2405.13203v1.pdf), cication: [**1**](https://scholar.google.com/scholar?cites=5955306685867710628&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Garrett Tanzer, Gustaf Ahdritz, Luke Melas-Kyriazi*
- **A Full-duplex Speech Dialogue Scheme Based On Large Language Models**, `arXiv, 2405.19487`, [arxiv](http://arxiv.org/abs/2405.19487v1), [pdf](http://arxiv.org/pdf/2405.19487v1.pdf), cication: [**-1**](None)

	 *Peng Wang, Songshuo Lu, Yaohua Tang, Sijie Yan, Yuanjun Xiong, Wei Xia*
- [**predictivechat**](https://github.com/yoheinakajima/predictivechat?tab=readme-ov-file) - yoheinakajima ![Star](https://img.shields.io/github/stars/yoheinakajima/predictivechat.svg?style=social&label=Star)

	 *Demo of AI chatbot that predicts user message to generate response quickly.*
- **TurnGPT: a Transformer-based Language Model for Predicting Turn-taking
  in Spoken Dialog**, `arXiv, 2010.10874`, [arxiv](http://arxiv.org/abs/2010.10874v1), [pdf](http://arxiv.org/pdf/2010.10874v1.pdf), cication: [**45**](https://scholar.google.com/scholar?cites=4498969182199038561&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Erik Ekstedt, Gabriel Skantze*


## Tutorials
- [84、GPT-4o全双工实时语音对话算法讲解\_哔哩哔哩\_bilibili](https://www.bilibili.com/video/BV1VQCUYyE6a/?spm_id_from=333.999.list.card_archive.click&vd_source=63e5fa02f07bfd58e74de3c6d149e31f)
- [Spoken LLM (v11).pdf - Google Drive](https://drive.google.com/file/d/1gPjnjGKxeCF72gisPVuQlDvogXQCtNk4/view)
- [Moshi (@kyutai_labs) is an unpolished e2e *full-duplex* model](https://x.com/JulianSlzr/status/1810303916686577858)
- [SNAC with flattening & reconstruction - YouTube](https://www.youtube.com/watch?v=NwZufAJxmMA&ab_channel=DemocratizingAI)

## Datasets
- https://huggingface.co/datasets/TwoAbove/the-project-gutenberg-open-audiobook-collection
- https://huggingface.co/datasets/EQ4You/Emotional_Speech ( gender labels are broken → “Male” and “female” need to be removed from all the captions, man and Woman need to be replaced with Person )
- https://huggingface.co/datasets/speechcolab/gigaspeech
- https://huggingface.co/datasets/parler-tts/mls-eng-10k-tags_tagged_10k_generated/viewer/default/train
- https://huggingface.co/datasets/krishnakalyan3/emo_300k 
- https://huggingface.co/datasets/mozilla-foundation/common_voice_17_0
- https://huggingface.co/datasets/facebook/multilingual_librispeech 
- https://huggingface.co/datasets/librispeech_asr 
- https://huggingface.co/collections/marianna13/laion-audio-630k-65aff8bbaa335c2842f3a730 
- https://huggingface.co/datasets/blanchon/udio_dataset 


- https://huggingface.co/datasets/ChristophSchuhmann/yt-urls-for-emotional-tts
- https://huggingface.co/datasets/ChristophSchuhmann/docu-clips
- https://huggingface.co/datasets/ChristophSchuhmann/movie-clips

- [collabora/librilight-processed-webdataset at main](https://huggingface.co/datasets/collabora/librilight-processed-webdataset/tree/main)
- [LAION-Audio-630k - a marianna13 Collection](https://huggingface.co/collections/marianna13/laion-audio-630k-65aff8bbaa335c2842f3a730)

### LLM
- [**SlimOrca-Dedup**](https://huggingface.co/datasets/Open-Orca/SlimOrca-Dedup?row=0) - Open-Orca 🤗

## Evaluation
- **SD-Eval: A Benchmark Dataset for Spoken Dialogue Understanding Beyond
  Words**, `arXiv, 2406.13340`, [arxiv](http://arxiv.org/abs/2406.13340v1), [pdf](http://arxiv.org/pdf/2406.13340v1.pdf), cication: [**-1**](None)

	 *Junyi Ao, Yuancheng Wang, Xiaohai Tian, Dekun Chen, Jun Zhang, Lu Lu, Yuxuan Wang, Haizhou Li, Zhizheng Wu* · ([SD-Eval](https://github.com/amphionspace/SD-Eval) - amphionspace) ![Star](https://img.shields.io/github/stars/amphionspace/SD-Eval.svg?style=social&label=Star)
## Products
- [Bland.ai](https://x.com/usebland/status/1838690781470822456)
- [LiveKit · GitHub](https://github.com/livekit)
- [Introducing Empathic Voice Interface 2 (EVI 2)](https://x.com/hume_ai/status/1833906262351974483)
- [Sindarin — Build your own Conversational Speech AI.](https://www.sindarin.tech/)
- [Introducing Deepgram Aura: Lightning Fast Text-to-Speech for Voice AI Agents | Deepgram](https://deepgram.com/learn/aura-text-to-speech-tts-api-voice-ai-agents-launch)

## Demos
- [ChatGPT heavy breathing and shouting : r/singularity](https://www.reddit.com/r/singularity/comments/1eskpsb/chatgpt_heavy_breathing_and_shouting/?utm_source=ainews&utm_medium=email&utm_campaign=ainews-not-much-happened-today-5446)