# Awesome music generation

- [Awesome music generation](#awesome-music-generation)
	- [Papers](#papers)
	- [Misc](#misc)
	- [Datasets](#datasets)
	- [Products](#products)
	- [Other](#other)
	- [Extra reference](#extra-reference)

## Papers
- **Presto! Distilling Steps and Layers for Accelerating Music Generation**, `arXiv, 2410.05167`, [arxiv](http://arxiv.org/abs/2410.05167v1), [pdf](http://arxiv.org/pdf/2410.05167v1.pdf), cication: [**-1**](None)

	 *Zachary Novack, Ge Zhu, Jonah Casebeer, Julian McAuley, Taylor Berg-Kirkpatrick, Nicholas J. Bryan*
- **QA-MDT: Quality-aware Masked Diffusion Transformer for Enhanced Music
  Generation**, `arXiv, 2405.15863`, [arxiv](http://arxiv.org/abs/2405.15863v2), [pdf](http://arxiv.org/pdf/2405.15863v2.pdf), cication: [**-1**](None)

	 *Chang Li, Ruoyu Wang, Lijuan Liu, Jun Du, Yixuan Sun, Zilu Guo, Zhenrong Zhang, Yuan Jiang*

	 · ([huggingface](https://huggingface.co/jadechoghari/openmusic))
- **Seed-Music: A Unified Framework for High Quality and Controlled Music
  Generation**, `arXiv, 2409.09214`, [arxiv](http://arxiv.org/abs/2409.09214v3), [pdf](http://arxiv.org/pdf/2409.09214v3.pdf), cication: [**-1**](None)

	 *Ye Bai, Haonan Chen, Jitong Chen, Zhuo Chen, Yi Deng, Xiaohong Dong, Lamtharn Hantrakul, Weituo Hao, Qingqing Huang, Zhongyi Huang*

	 · ([team.doubao](https://team.doubao.com/seed-music))
- **VMAS: Video-to-Music Generation via Semantic Alignment in Web Music
  Videos**, `arXiv, 2409.07450`, [arxiv](http://arxiv.org/abs/2409.07450v1), [pdf](http://arxiv.org/pdf/2409.07450v1.pdf), cication: [**-1**](None)

	 *Yan-Bo Lin, Yu Tian, Linjie Yang, Gedas Bertasius, Heng Wang* · ([genjib.github](https://genjib.github.io/project_page/VMAs/index.html))
- **SongCreator: Lyrics-based Universal Song Generation**, `arXiv, 2409.06029`, [arxiv](http://arxiv.org/abs/2409.06029v1), [pdf](http://arxiv.org/pdf/2409.06029v1.pdf), cication: [**-1**](None)

	 *Shun Lei, Yixuan Zhou, Boshi Tang, Max W. Y. Lam, Feng Liu, Hangyu Liu, Jingcheng Wu, Shiyin Kang, Zhiyong Wu, Helen Meng* · ([songcreator.github](https://songcreator.github.io/))
- **FLUX that Plays Music**, `arXiv, 2409.00587`, [arxiv](http://arxiv.org/abs/2409.00587v1), [pdf](http://arxiv.org/pdf/2409.00587v1.pdf), cication: [**1**](https://scholar.google.com/scholar?cites=18093944222213983715&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Zhengcong Fei, Mingyuan Fan, Changqian Yu, Junshi Huang* · ([FluxMusic](https://github.com/feizc/FluxMusic) - feizc) ![Star](https://img.shields.io/github/stars/feizc/FluxMusic.svg?style=social&label=Star) · ([huggingface](https://huggingface.co/spaces/flosstradamus/FluxMusicGUI))
- **Foundation Models for Music: A Survey**, `arXiv, 2408.14340`, [arxiv](http://arxiv.org/abs/2408.14340v3), [pdf](http://arxiv.org/pdf/2408.14340v3.pdf), cication: [**-1**](None)

	 *Yinghao Ma, Anders Øland, Anton Ragni, Bleiz MacSen Del Sette, Charalampos Saitis, Chris Donahue, Chenghua Lin, Christos Plachouras, Emmanouil Benetos, Elona Shatri* · ([FM4Music](https://github.com/nicolaus625/FM4Music) - nicolaus625) ![Star](https://img.shields.io/github/stars/nicolaus625/FM4Music.svg?style=social&label=Star)
- **Audio Conditioning for Music Generation via Discrete Bottleneck Features**, `arXiv, 2407.12563`, [arxiv](http://arxiv.org/abs/2407.12563v2), [pdf](http://arxiv.org/pdf/2407.12563v2.pdf), cication: [**-1**](None)

	 *Simon Rouard, Yossi Adi, Jade Copet, Axel Roebel, Alexandre Défossez* · ([musicgenstyle.github](https://musicgenstyle.github.io/))
- **MusiConGen: Rhythm and Chord Control for Transformer-Based Text-to-Music
  Generation**, `arXiv, 2407.15060`, [arxiv](http://arxiv.org/abs/2407.15060v1), [pdf](http://arxiv.org/pdf/2407.15060v1.pdf), cication: [**1**](https://scholar.google.com/scholar?cites=5143147573772197272&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Yun-Han Lan, Wen-Yi Hsiao, Hao-Chung Cheng, Yi-Hsuan Yang* · ([musicongen.github](https://musicongen.github.io/musicongen_demo/))
- [High Fidelity Text-Guided Music Generation and Editing via Single-Stage Flow Matching](https://melodyflow.github.io/)
- **Joint Audio and Symbolic Conditioning for Temporally Controlled
  Text-to-Music Generation**, `arXiv, 2406.10970`, [arxiv](http://arxiv.org/abs/2406.10970v1), [pdf](http://arxiv.org/pdf/2406.10970v1.pdf), cication: [**-1**](None)

	 *Or Tal, Alon Ziv, Itai Gat, Felix Kreuk, Yossi Adi* · ([pages.cs.huji.ac](https://pages.cs.huji.ac.il/adiyoss-lab/JASCO/)) · ([audiocraft](https://github.com/facebookresearch/audiocraft/blob/main/docs/JASCO.md) - facebookresearch) ![Star](https://img.shields.io/github/stars/facebookresearch/audiocraft.svg?style=social&label=Star)
- [**stable-audio-open-1.0**](https://huggingface.co/stabilityai/stable-audio-open-1.0) - stabilityai 🤗

	 · ([notebooks](https://github.com/Vaibhavs10/notebooks/blob/main/stable_audio_open_colab.ipynb) - Vaibhavs10) ![Star](https://img.shields.io/github/stars/Vaibhavs10/notebooks.svg?style=social&label=Star)
- **DITTO-2: Distilled Diffusion Inference-Time T-Optimization for Music
  Generation**, `arXiv, 2405.20289`, [arxiv](http://arxiv.org/abs/2405.20289v1), [pdf](http://arxiv.org/pdf/2405.20289v1.pdf), cication: [**-1**](None)

	 *Zachary Novack, Julian McAuley, Taylor Berg-Kirkpatrick, Nicholas Bryan* · ([ditto-music.github](https://ditto-music.github.io/ditto2/))
- **Instruct-MusicGen: Unlocking Text-to-Music Editing for Music Language
  Models via Instruction Tuning**, `arXiv, 2405.18386`, [arxiv](http://arxiv.org/abs/2405.18386v1), [pdf](http://arxiv.org/pdf/2405.18386v1.pdf), cication: [**-1**](None)

	 *Yixiao Zhang, Yukara Ikemiya, Woosung Choi, Naoki Murata, Marco A. Martínez-Ramírez, Liwei Lin, Gus Xia, Wei-Hsiang Liao, Yuki Mitsufuji, Simon Dixon*

	 · ([instruct-musicgen](https://github.com/ldzhangyx/instruct-musicgen) - ldzhangyx) ![Star](https://img.shields.io/github/stars/ldzhangyx/instruct-musicgen.svg?style=social&label=Star)
- **Naturalistic Music Decoding from EEG Data via Latent Diffusion Models**, `arXiv, 2405.09062`, [arxiv](http://arxiv.org/abs/2405.09062v1), [pdf](http://arxiv.org/pdf/2405.09062v1.pdf), cication: [**-1**](None)

	 *Emilian Postolache, Natalia Polouliakh, Hiroaki Kitano, Akima Connelly, Emanuele Rodolà, Taketo Akama*
- **Music Consistency Models**, `arXiv, 2404.13358`, [arxiv](http://arxiv.org/abs/2404.13358v1), [pdf](http://arxiv.org/pdf/2404.13358v1.pdf), cication: [**-1**](None)

	 *Zhengcong Fei, Mingyuan Fan, Junshi Huang*
- **Long-form music generation with latent diffusion**, `arXiv, 2404.10301`, [arxiv](http://arxiv.org/abs/2404.10301v1), [pdf](http://arxiv.org/pdf/2404.10301v1.pdf), cication: [**-1**](None)

	 *Zach Evans, Julian D. Parker, CJ Carr, Zack Zukowski, Josiah Taylor, Jordi Pons*
- **Text-to-Song: Towards Controllable Music Generation Incorporating Vocals
  and Accompaniment**, `arXiv, 2404.09313`, [arxiv](http://arxiv.org/abs/2404.09313v1), [pdf](http://arxiv.org/pdf/2404.09313v1.pdf), cication: [**-1**](None)

	 *Hong Zhiqing, Huang Rongjie, Cheng Xize, Wang Yongqi, Li Ruiqi, You Fuming, Zhao Zhou, Zhang Zhimeng* · ([text2songmelodist.github](https://text2songmelodist.github.io/Sample/))
- **MuPT: A Generative Symbolic Music Pretrained Transformer**, `arXiv, 2404.06393`, [arxiv](http://arxiv.org/abs/2404.06393v1), [pdf](http://arxiv.org/pdf/2404.06393v1.pdf), cication: [**-1**](None)

	 *Xingwei Qu, Yuelin Bai, Yinghao Ma, Ziya Zhou, Ka Man Lo, Jiaheng Liu, Ruibin Yuan, Lejun Min, Xueling Liu, Tianyu Zhang* · ([map-mupt.github](https://map-mupt.github.io/))
- **Prompt-Singer: Controllable Singing-Voice-Synthesis with Natural
  Language Prompt**, `arXiv, 2403.11780`, [arxiv](http://arxiv.org/abs/2403.11780v1), [pdf](http://arxiv.org/pdf/2403.11780v1.pdf), cication: [**-1**](None)

	 *Yongqi Wang, Ruofan Hu, Rongjie Huang, Zhiqing Hong, Ruiqi Li, Wenrui Liu, Fuming You, Tao Jin, Zhou Zhao*

	 · ([prompt-singer.github](https://prompt-singer.github.io/))
- **MusicHiFi: Fast High-Fidelity Stereo Vocoding**, `arXiv, 2403.10493`, [arxiv](http://arxiv.org/abs/2403.10493v1), [pdf](http://arxiv.org/pdf/2403.10493v1.pdf), cication: [**-1**](None)

	 *Ge Zhu, Juan-Pablo Caceres, Zhiyao Duan, Nicholas J. Bryan*

	 · ([musichifi.github](https://musichifi.github.io/web/))
- [**musiclang_predict**](https://github.com/MusicLang/musiclang_predict) - MusicLang ![Star](https://img.shields.io/github/stars/MusicLang/musiclang_predict.svg?style=social&label=Star)

	 *AI Prediction api of the MusicLang package* · ([huggingface](https://huggingface.co/musiclang/musiclang-v2))
- **ChatMusician: Understanding and Generating Music Intrinsically with LLM**, `arXiv, 2402.16153`, [arxiv](http://arxiv.org/abs/2402.16153v1), [pdf](http://arxiv.org/pdf/2402.16153v1.pdf), cication: [**-1**](None)

	 *Ruibin Yuan, Hanfeng Lin, Yi Wang, Zeyue Tian, Shangda Wu, Tianhao Shen, Ge Zhang, Yuhang Wu, Cong Liu, Ziya Zhou*
- **MusicMagus: Zero-Shot Text-to-Music Editing via Diffusion Models**, `arXiv, 2402.06178`, [arxiv](http://arxiv.org/abs/2402.06178v1), [pdf](http://arxiv.org/pdf/2402.06178v1.pdf), cication: [**-1**](None)

	 *Yixiao Zhang, Yukara Ikemiya, Gus Xia, Naoki Murata, Marco Martínez, Wei-Hsiang Liao, Yuki Mitsufuji, Simon Dixon* · ([wry-neighbor-173.notion](https://wry-neighbor-173.notion.site/MusicMagus-Zero-Shot-Text-to-Music-Editing-via-Diffusion-Models-8f55a82f34944eb9a4028ca56c546d9d))
- **MusicRL: Aligning Music Generation to Human Preferences**, `arXiv, 2402.04229`, [arxiv](http://arxiv.org/abs/2402.04229v1), [pdf](http://arxiv.org/pdf/2402.04229v1.pdf), cication: [**-1**](None)

	 *Geoffrey Cideron, Sertan Girgin, Mauro Verzetti, Damien Vincent, Matej Kastelic, Zalán Borsos, Brian McWilliams, Victor Ungureanu, Olivier Bachem, Olivier Pietquin* · ([google-research.github](https://google-research.github.io/seanet/musiclm/rlhf/))
- **DITTO: Diffusion Inference-Time T-Optimization for Music Generation**, `arXiv, 2401.12179`, [arxiv](http://arxiv.org/abs/2401.12179v1), [pdf](http://arxiv.org/pdf/2401.12179v1.pdf), cication: [**-1**](None)

	 *Zachary Novack, Julian McAuley, Taylor Berg-Kirkpatrick, Nicholas J. Bryan* · ([ditto-music.github](https://ditto-music.github.io/web/))
- **Masked Audio Generation using a Single Non-Autoregressive Transformer**, `arXiv, 2401.04577`, [arxiv](http://arxiv.org/abs/2401.04577v1), [pdf](http://arxiv.org/pdf/2401.04577v1.pdf), cication: [**-1**](None)

	 *Alon Ziv, Itai Gat, Gael Le Lan, Tal Remez, Felix Kreuk, Alexandre Défossez, Jade Copet, Gabriel Synnaeve, Yossi Adi* · ([pages.cs.huji.ac](https://pages.cs.huji.ac.il/adiyoss-lab/MAGNeT/)) · ([audiocraft](https://github.com/facebookresearch/audiocraft/blob/main/docs/MAGNET.md) - facebookresearch) ![Star](https://img.shields.io/github/stars/facebookresearch/audiocraft.svg?style=social&label=Star) · ([MAGNeT-colab](https://github.com/camenduru/MAGNeT-colab) - camenduru) ![Star](https://img.shields.io/github/stars/camenduru/MAGNeT-colab.svg?style=social&label=Star) · ([huggingface](https://huggingface.co/spaces/fffiloni/MAGNet))
- **StemGen: A music generation model that listens**, `arXiv, 2312.08723`, [arxiv](http://arxiv.org/abs/2312.08723v2), [pdf](http://arxiv.org/pdf/2312.08723v2.pdf), cication: [**1**](https://scholar.google.com/scholar?cites=10062595949841368221&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Julian D. Parker, Janne Spijkervet, Katerina Kosta, Furkan Yesiler, Boris Kuznetsov, Ju-Chiang Wang, Matt Avent, Jitong Chen, Duc Le*
- **M$^{2}$UGen: Multi-modal Music Understanding and Generation with the
  Power of Large Language Models**, `arXiv, 2311.11255`, [arxiv](http://arxiv.org/abs/2311.11255v3), [pdf](http://arxiv.org/pdf/2311.11255v3.pdf), cication: [**-1**](None)

	 *Atin Sakkeer Hussain, Shansong Liu, Chenshuo Sun, Ying Shan* · ([M2UGen](https://github.com/shansongliu/M2UGen/tree/main) - shansongliu) ![Star](https://img.shields.io/github/stars/shansongliu/M2UGen.svg?style=social&label=Star) · ([crypto-code.github](https://crypto-code.github.io/M2UGen-Demo/))
- **Mustango: Toward Controllable Text-to-Music Generation**, `arXiv, 2311.08355`, [arxiv](http://arxiv.org/abs/2311.08355v1), [pdf](http://arxiv.org/pdf/2311.08355v1.pdf), cication: [**-1**](None)

	 *Jan Melechovsky, Zixun Guo, Deepanway Ghosal, Navonil Majumder, Dorien Herremans, Soujanya Poria* · ([mustango](https://github.com/AMAAI-Lab/mustango) - AMAAI-Lab) ![Star](https://img.shields.io/github/stars/AMAAI-Lab/mustango.svg?style=social&label=Star) · ([huggingface](https://huggingface.co/spaces/declare-lab/mustango))
- **Music ControlNet: Multiple Time-varying Controls for Music Generation**, `arXiv, 2311.07069`, [arxiv](http://arxiv.org/abs/2311.07069v1), [pdf](http://arxiv.org/pdf/2311.07069v1.pdf), cication: [**1**](https://scholar.google.com/scholar?cites=8629820552718202413&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Shih-Lun Wu, Chris Donahue, Shinji Watanabe, Nicholas J. Bryan* · ([MusicControlNet.github](https://MusicControlNet.github.io/web/))
- **Controllable Music Production with Diffusion Models and Guidance
  Gradients**, `arXiv, 2311.00613`, [arxiv](http://arxiv.org/abs/2311.00613v2), [pdf](http://arxiv.org/pdf/2311.00613v2.pdf), cication: [**1**](https://scholar.google.com/scholar?cites=11698994502539626248&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Mark Levy, Bruno Di Giorgi, Floris Weers, Angelos Katharopoulos, Tom Nickson*
- **Loop Copilot: Conducting AI Ensembles for Music Generation and Iterative
  Editing**, `arXiv, 2310.12404`, [arxiv](http://arxiv.org/abs/2310.12404v1), [pdf](http://arxiv.org/pdf/2310.12404v1.pdf), cication: [**1**](https://scholar.google.com/scholar?cites=11168220935398762749&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Yixiao Zhang, Akira Maezawa, Gus Xia, Kazuhiko Yamamoto, Simon Dixon*
- **MusicAgent: An AI Agent for Music Understanding and Generation with
  Large Language Models**, `arXiv, 2310.11954`, [arxiv](http://arxiv.org/abs/2310.11954v2), [pdf](http://arxiv.org/pdf/2310.11954v2.pdf), cication: [**-1**](None)

	 *Dingyao Yu, Kaitao Song, Peiling Lu, Tianyu He, Xu Tan, Wei Ye, Shikun Zhang, Jiang Bian*
- **UniAudio: An Audio Foundation Model Toward Universal Audio Generation**, `arXiv, 2310.00704`, [arxiv](http://arxiv.org/abs/2310.00704v5), [pdf](http://arxiv.org/pdf/2310.00704v5.pdf), cication: [**5**](https://scholar.google.com/scholar?cites=6416249801268158267&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Dongchao Yang, Jinchuan Tian, Xu Tan, Rongjie Huang, Songxiang Liu, Xuankai Chang, Jiatong Shi, Sheng Zhao, Jiang Bian, Xixin Wu* · ([UniAudio](https://github.com/yangdongchao/UniAudio) - yangdongchao) ![Star](https://img.shields.io/github/stars/yangdongchao/UniAudio.svg?style=social&label=Star) · ([dongchaoyang](http://dongchaoyang.top/UniAudio_demo/))
- **AudioLDM 2: Learning Holistic Audio Generation with Self-supervised
  Pretraining**, `arXiv, 2308.05734`, [arxiv](http://arxiv.org/abs/2308.05734v2), [pdf](http://arxiv.org/pdf/2308.05734v2.pdf), cication: [**7**](https://scholar.google.com/scholar?cites=13863968994495871256&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Haohe Liu, Qiao Tian, Yi Yuan, Xubo Liu, Xinhao Mei, Qiuqiang Kong, Yuping Wang, Wenwu Wang, Yuxuan Wang, Mark D. Plumbley* · ([AudioLDM2](https://github.com/haoheliu/AudioLDM2) - haoheliu) ![Star](https://img.shields.io/github/stars/haoheliu/AudioLDM2.svg?style=social&label=Star) · ([audioldm.github](https://audioldm.github.io/audioldm2/)) · ([huggingface](https://huggingface.co/spaces/haoheliu/audioldm2-text2audio-text2music))
- **JEN-1: Text-Guided Universal Music Generation with Omnidirectional
  Diffusion Models**, `arXiv, 2308.04729`, [arxiv](http://arxiv.org/abs/2308.04729v1), [pdf](http://arxiv.org/pdf/2308.04729v1.pdf), cication: [**6**](https://scholar.google.com/scholar?cites=12822402398273448433&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Peike Li, Boyu Chen, Yao Yao, Yikai Wang, Allen Wang, Alex Wang* · ([futureverse](http://futureverse.com/research/jen/demos/jen1))
- **From Discrete Tokens to High-Fidelity Audio Using Multi-Band Diffusion**, `arXiv, 2308.02560`, [arxiv](http://arxiv.org/abs/2308.02560v2), [pdf](http://arxiv.org/pdf/2308.02560v2.pdf), cication: [**1**](https://scholar.google.com/scholar?cites=17456074958898859167&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Robin San Roman, Yossi Adi, Antoine Deleforge, Romain Serizel, Gabriel Synnaeve, Alexandre Défossez* · ([audiocraft_plus](https://github.com/GrandaddyShmax/audiocraft_plus) - GrandaddyShmax) ![Star](https://img.shields.io/github/stars/GrandaddyShmax/audiocraft_plus.svg?style=social&label=Star) · ([arxiv](https://arxiv.org/abs/2306.05284)) · ([audiocraft](https://github.com/facebookresearch/audiocraft/blob/main/docs/MUSICGEN.md) - facebookresearch) ![Star](https://img.shields.io/github/stars/facebookresearch/audiocraft.svg?style=social&label=Star) · ([huggingface](https://huggingface.co/spaces/facebook/MusicGen)) · ([ai.honu](https://ai.honu.io/papers/musicgen/)) · ([huggingface](https://huggingface.co/spaces/sanchit-gandhi/musicgen-streaming)) · ([huggingface](https://huggingface.co/spaces/reach-vb/musicgen-prompt-upsampling))
- **EmoGen: Eliminating Subjective Bias in Emotional Music Generation**, `arXiv, 2307.01229`, [arxiv](http://arxiv.org/abs/2307.01229v1), [pdf](http://arxiv.org/pdf/2307.01229v1.pdf), cication: [**-1**](None)

	 *Chenfei Kang, Peiling Lu, Botao Yu, Xu Tan, Wei Ye, Shikun Zhang, Jiang Bian* · ([ai-muzic.github](https://ai-muzic.github.io/emogen/)) · ([muzic](https://github.com/microsoft/muzic/tree/main/emogen) - microsoft) ![Star](https://img.shields.io/github/stars/microsoft/muzic.svg?style=social&label=Star)
- **VampNet: Music Generation via Masked Acoustic Token Modeling**, `arXiv, 2307.04686`, [arxiv](http://arxiv.org/abs/2307.04686v2), [pdf](http://arxiv.org/pdf/2307.04686v2.pdf), cication: [**13**](https://scholar.google.com/scholar?cites=4599642694858157010&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Hugo Flores Garcia, Prem Seetharaman, Rithesh Kumar, Bryan Pardo* · ([vampnet](https://github.com/hugofloresgarcia/vampnet) - hugofloresgarcia) ![Star](https://img.shields.io/github/stars/hugofloresgarcia/vampnet.svg?style=social&label=Star)
- **Anticipatory Music Transformer**, `arXiv, 2306.08620`, [arxiv](http://arxiv.org/abs/2306.08620v1), [pdf](http://arxiv.org/pdf/2306.08620v1.pdf), cication: [**5**](https://scholar.google.com/scholar?cites=13816719672975791572&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *John Thickstun, David Hall, Chris Donahue, Percy Liang* · ([anticipation](https://github.com/jthickstun/anticipation) - jthickstun) ![Star](https://img.shields.io/github/stars/jthickstun/anticipation.svg?style=social&label=Star)
- **Efficient Neural Music Generation**, `arXiv, 2305.15719`, [arxiv](http://arxiv.org/abs/2305.15719v1), [pdf](http://arxiv.org/pdf/2305.15719v1.pdf), cication: [**10**](https://scholar.google.com/scholar?cites=13987278157292993267&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Max W. Y. Lam, Qiao Tian, Tang Li, Zongyu Yin, Siyuan Feng, Ming Tu, Yuliang Ji, Rui Xia, Mingbo Ma, Xuchen Song* · ([efficient-melody.github](https://efficient-melody.github.io/))
- **MusicLM: Generating Music From Text**, `arXiv, 2301.11325`, [arxiv](http://arxiv.org/abs/2301.11325v1), [pdf](http://arxiv.org/pdf/2301.11325v1.pdf), cication: [**219**](https://scholar.google.com/scholar?cites=17376728213237187356&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Andrea Agostinelli, Timo I. Denk, Zalán Borsos, Jesse Engel, Mauro Verzetti, Antoine Caillon, Qingqing Huang, Aren Jansen, Adam Roberts, Marco Tagliasacchi* · ([google-research.github](https://google-research.github.io/seanet/musiclm/examples)) · ([aitestkitchen.withgoogle](https://aitestkitchen.withgoogle.com/experiments/music-lm))
- [**jukebox-diffusion**](https://github.com/jmoso13/jukebox-diffusion) - jmoso13 ![Star](https://img.shields.io/github/stars/jmoso13/jukebox-diffusion.svg?style=social&label=Star)

	 · ([betterprogramming](https://betterprogramming.pub/jukebox-diffusion-cbe22ff3cd47))
- **A Review of Intelligent Music Generation Systems**, `arXiv, 2211.09124`, [arxiv](http://arxiv.org/abs/2211.09124v3), [pdf](http://arxiv.org/pdf/2211.09124v3.pdf), cication: [**4**](https://scholar.google.com/scholar?cites=10451124770455857194&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Lei Wang, Ziyi Zhao, Hanwei Liu, Junwei Pang, Yi Qin, Qidi Wu*

## Misc
- [**musicgen-songstarter-demo**](https://huggingface.co/spaces/artificialguybr/musicgen-songstarter-demo) - artificialguybr 🤗
- [**rwkv-music**](https://huggingface.co/spaces/mrfakename/rwkv-music) - mrfakename 🤗
- **Video2Music: Suitable Music Generation from Videos using an Affective
  Multimodal Transformer model**, `arXiv, 2311.00968`, [arxiv](http://arxiv.org/abs/2311.00968v1), [pdf](http://arxiv.org/pdf/2311.00968v1.pdf), cication: [**-1**](None)

	 *Jaeyong Kang, Soujanya Poria, Dorien Herremans*
- **Controllable Music Production with Diffusion Models and Guidance
  Gradients**, `arXiv, 2311.00613`, [arxiv](http://arxiv.org/abs/2311.00613v2), [pdf](http://arxiv.org/pdf/2311.00613v2.pdf), cication: [**1**](https://scholar.google.com/scholar?cites=11698994502539626248&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Mark Levy, Bruno Di Giorgi, Floris Weers, Angelos Katharopoulos, Tom Nickson*
- **Fast Diffusion GAN Model for Symbolic Music Generation Controlled by
  Emotions**, `arXiv, 2310.14040`, [arxiv](http://arxiv.org/abs/2310.14040v1), [pdf](http://arxiv.org/pdf/2310.14040v1.pdf), cication: [**-1**](None)

	 *Jincheng Zhang, György Fazekas, Charalampos Saitis*
- [**riffusion**](https://github.com/riffusion/riffusion) - riffusion ![Star](https://img.shields.io/github/stars/riffusion/riffusion.svg?style=social&label=Star)

	 *Stable diffusion for real-time music generation*
- [🎵 The MusicBox - a fffiloni Collection](https://huggingface.co/collections/fffiloni/the-musicbox-65001a16a5c11e3a9af3adf8)
- **ERNIE-Music: Text-to-Waveform Music Generation with Diffusion Models**, `arXiv, 2302.04456`, [arxiv](http://arxiv.org/abs/2302.04456v2), [pdf](http://arxiv.org/pdf/2302.04456v2.pdf), cication: [**5**](https://scholar.google.com/scholar?cites=14355998510434709275&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Pengfei Zhu, Chao Pang, Yekun Chai, Lei Li, Shuohuan Wang, Yu Sun, Hao Tian, Hua Wu*
- **A Survey of AI Music Generation Tools and Models**, `arXiv, 2308.12982`, [arxiv](http://arxiv.org/abs/2308.12982v1), [pdf](http://arxiv.org/pdf/2308.12982v1.pdf), cication: [**1**](https://scholar.google.com/scholar?cites=6495689963686073520&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Yueyue Zhu, Jared Baca, Banafsheh Rekabdar, Reza Rawassizadeh*
- **Moûsai: Text-to-Music Generation with Long-Context Latent Diffusion**, `arXiv, 2301.11757`, [arxiv](http://arxiv.org/abs/2301.11757v3), [pdf](http://arxiv.org/pdf/2301.11757v3.pdf), cication: [**42**](https://scholar.google.com/scholar?cites=13093491623183223766&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Flavio Schneider, Ojasv Kamal, Zhijing Jin, Bernhard Schölkopf*

## Datasets
- **The Song Describer Dataset: a Corpus of Audio Captions for
  Music-and-Language Evaluation**, `arXiv, 2311.10057`, [arxiv](http://arxiv.org/abs/2311.10057v3), [pdf](http://arxiv.org/pdf/2311.10057v3.pdf), cication: [**-1**](None)

	 *Ilaria Manco, Benno Weck, SeungHeon Doh, Minz Won, Yixiao Zhang, Dmitry Bogdanov, Yusong Wu, Ke Chen, Philip Tovstogan, Emmanouil Benetos* · ([song-describer-dataset](https://github.com/mulab-mir/song-describer-dataset) - mulab-mir) ![Star](https://img.shields.io/github/stars/mulab-mir/song-describer-dataset.svg?style=social&label=Star) · ([huggingface](https://huggingface.co/datasets/mulab-mir/song-describer))
- [**MusicBench**](https://huggingface.co/datasets/amaai-lab/MusicBench) - amaai-lab 🤗

## Products
- [X](https://twitter.com/elevenlabsio/status/1788628171044053386)
- [Udio | Make your music](https://www.udio.com/)
- [Introducing Stable Audio 2.0](https://stability.ai/news/stable-audio-2-0)

	 · ([mp.weixin.qq](https://mp.weixin.qq.com/s?__biz=MzI3MTA0MTk1MA==&mid=2652463642&idx=1&sn=b1d50966d4a834b4e81d9635ccb4cd96))
- [Introducing v3 – Suno](https://www.suno.ai/blog/v3)

	 · ([mp.weixin.qq](https://mp.weixin.qq.com/s?__biz=MzI3MTA0MTk1MA==&mid=2652459759&idx=1&sn=df9abda1de52e47bfeda3835387b6918))
- [MusicFX](https://aitestkitchen.withgoogle.com/tools/music-fx?isMusicFxLive=true)
- [AIVA, the AI Music Generation Assistant](https://www.aiva.ai/)
- [Musicfy AI](https://musicfy.lol/)
- [Transforming the future of music creation - Google DeepMind](https://deepmind.google/discover/blog/transforming-the-future-of-music-creation/)

- [网易天音 - 一站式AI音乐创作工具 - 官网](https://tianyin.music.163.com/#/)
- [音乐ChatGPT时刻来临！「天工SkyMusic」音乐大模型今日启动邀测](https://mp.weixin.qq.com/s/LFuZ0EIPkLrM342JB1EF_A)

## Other
- [Site Unreachable](https://huggingface.co/spaces/enzostvs/ai-jukebox)
- [**Stable-Diffusion**](https://github.com/FurkanGozukara/Stable-Diffusion/blob/main/Tutorials/AI-Music-Generation-Audiocraft-Tutorial.md#more-info-about-top-k-top-p-temperature-and-classifier-free-guidance-from-chatgpt) - FurkanGozukara ![Star](https://img.shields.io/github/stars/FurkanGozukara/Stable-Diffusion.svg?style=social&label=Star)

## Extra reference
- [**awesome-deep-learning-music**](https://github.com/ybayle/awesome-deep-learning-music) - ybayle ![Star](https://img.shields.io/github/stars/ybayle/awesome-deep-learning-music.svg?style=social&label=Star)

	 *List of articles related to deep learning applied to music*