# Awesome Audio Generation and Understanding

- [Awesome Audio Generation and Understanding](#awesome-audio-generation-and-understanding)
  - [Audio Generation](#audio-generation)
  - [Speech Generation](#speech-generation)
  - [Audio Understanding](#audio-understanding)
  - [Image Generation With Audio](#image-generation-with-audio)
  - [Toolkits](#toolkits)
  - [Other](#other)

## Survey
- **A Survey of Foundation Models for Music Understanding**, `arXiv, 2409.09601`, [arxiv](http://arxiv.org/abs/2409.09601v1), [pdf](http://arxiv.org/pdf/2409.09601v1.pdf), cication: [**-1**](None)

	 *Wenjun Li, Ying Cai, Ziyang Wu, Wenyi Zhang, Yifan Chen, Rundong Qi, Mengqi Dong, Peigen Chen, Xiao Dong, Fenghao Shi*
- **A Survey of Deep Learning Audio Generation Methods**, `arXiv, 2406.00146`, [arxiv](http://arxiv.org/abs/2406.00146v1), [pdf](http://arxiv.org/pdf/2406.00146v1.pdf), cication: [**-1**](None)

	 *Matej Božić, Marko Horvat*
	 
- **Towards audio language modeling -- an overview**, `arXiv, 2402.13236`, [arxiv](http://arxiv.org/abs/2402.13236v1), [pdf](http://arxiv.org/pdf/2402.13236v1.pdf), cication: [**5**](https://scholar.google.com/scholar?cites=17312351433545398838&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Haibin Wu, Xuanjun Chen, Yi-Cheng Lin, Kai-wei Chang, Ho-Lam Chung, Alexander H. Liu, Hung-yi Lee*

## Audio Generation
- **UniMuMo: Unified Text, Music and Motion Generation**, `arXiv, 2410.04534`, [arxiv](http://arxiv.org/abs/2410.04534v1), [pdf](http://arxiv.org/pdf/2410.04534v1.pdf), cication: [**-1**](None)

	 *Han Yang, Kun Su, Yutong Zhang, Jiaben Chen, Kaizhi Qian, Gaowen Liu, Chuang Gan* · ([hanyangclarence.github](https://hanyangclarence.github.io/unimumo_demo/)) · ([UniMuMo](https://github.com/hanyangclarence/UniMuMo) - hanyangclarence) ![Star](https://img.shields.io/github/stars/hanyangclarence/UniMuMo.svg?style=social&label=Star)
- [Notes on the Movie Gen Audio Model by @AIatMeta](https://x.com/reach_vb/status/1842196182677811553)
- [**AudioEditor**](https://github.com/NKU-HLT/AudioEditor?tab=readme-ov-file) - NKU-HLT ![Star](https://img.shields.io/github/stars/NKU-HLT/AudioEditor.svg?style=social&label=Star)
- **EzAudio: Enhancing Text-to-Audio Generation with Efficient Diffusion
  Transformer**, `arXiv, 2409.10819`, [arxiv](http://arxiv.org/abs/2409.10819v1), [pdf](http://arxiv.org/pdf/2409.10819v1.pdf), cication: [**-1**](None)

	 *Jiarui Hai, Yong Xu, Hao Zhang, Chenxing Li, Helin Wang, Mounya Elhilali, Dong Yu*

	 · ([haidog-yaqub.github](https://haidog-yaqub.github.io/EzAudio-Page/)) · ([EzAudio](https://github.com/haidog-yaqub/EzAudio) - haidog-yaqub) ![Star](https://img.shields.io/github/stars/haidog-yaqub/EzAudio.svg?style=social&label=Star)
- **Draw an Audio: Leveraging Multi-Instruction for Video-to-Audio Synthesis**, `arXiv, 2409.06135`, [arxiv](http://arxiv.org/abs/2409.06135v1), [pdf](http://arxiv.org/pdf/2409.06135v1.pdf), cication: [**-1**](None)

	 *Qi Yang, Binjie Mao, Zili Wang, Xing Nie, Pengfei Gao, Ying Guo, Cheng Zhen, Pengfei Yan, Shiming Xiang* · ([yannqi.github](https://yannqi.github.io/Draw-an-Audio/))
- **Accelerating High-Fidelity Waveform Generation via Adversarial Flow
  Matching Optimization**, `arXiv, 2408.08019`, [arxiv](http://arxiv.org/abs/2408.08019v1), [pdf](http://arxiv.org/pdf/2408.08019v1.pdf), cication: [**-1**](None)

	 *Sang-Hoon Lee, Ha-Yeong Choi, Seong-Whan Lee* · ([PeriodWave](https://github.com/sh-lee-prml/PeriodWave) - sh-lee-prml) ![Star](https://img.shields.io/github/stars/sh-lee-prml/PeriodWave.svg?style=social&label=Star)
- **PeriodWave: Multi-Period Flow Matching for High-Fidelity Waveform
  Generation**, `arXiv, 2408.07547`, [arxiv](http://arxiv.org/abs/2408.07547v1), [pdf](http://arxiv.org/pdf/2408.07547v1.pdf), cication: [**1**](https://scholar.google.com/scholar?cites=14553664054487650270&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Sang-Hoon Lee, Ha-Yeong Choi, Seong-Whan Lee* · ([PeriodWave](https://github.com/sh-lee-prml/PeriodWave) - sh-lee-prml) ![Star](https://img.shields.io/github/stars/sh-lee-prml/PeriodWave.svg?style=social&label=Star) · ([periodwave.github](https://periodwave.github.io/demo/))
- **Long-form music generation with latent diffusion**, `arXiv, 2404.10301`, [arxiv](http://arxiv.org/abs/2404.10301v1), [pdf](http://arxiv.org/pdf/2404.10301v1.pdf), cication: [**6**](https://scholar.google.com/scholar?cites=17579374849381815722&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Zach Evans, Julian D. Parker, CJ Carr, Zack Zukowski, Josiah Taylor, Jordi Pons* · ([stability-ai.github](https://stability-ai.github.io/stable-audio-open-demo/)) · ([huggingface](https://huggingface.co/stabilityai/stable-audio-open-1.0))
- **Video-to-Audio Generation with Hidden Alignment**, `arXiv, 2407.07464`, [arxiv](http://arxiv.org/abs/2407.07464v1), [pdf](http://arxiv.org/pdf/2407.07464v1.pdf), cication: [**-1**](None)

	 *Manjie Xu, Chenxing Li, Yong Ren, Rilin Chen, Yu Gu, Wei Liang, Dong Yu* · ([sites.google](https://sites.google.com/view/vta-ldm))
- **Read, Watch and Scream! Sound Generation from Text and Video**, `arXiv, 2407.05551`, [arxiv](http://arxiv.org/abs/2407.05551v1), [pdf](http://arxiv.org/pdf/2407.05551v1.pdf), cication: [**-1**](None)

	 *Yujin Jeong, Yunji Kim, Sanghyuk Chun, Jiyoung Lee* · ([rewas](https://github.com/naver-ai/rewas) - naver-ai) ![Star](https://img.shields.io/github/stars/naver-ai/rewas.svg?style=social&label=Star) · ([naver-ai.github](https://naver-ai.github.io/rewas/))
- [PicoAudio Demo](https://picoaudio.github.io/)
- **FoleyCrafter: Bring Silent Videos to Life with Lifelike and Synchronized
  Sounds**, `arXiv, 2407.01494`, [arxiv](http://arxiv.org/abs/2407.01494v1), [pdf](http://arxiv.org/pdf/2407.01494v1.pdf), cication: [**-1**](None)

	 *Yiming Zhang, Yicheng Gu, Yanhong Zeng, Zhening Xing, Yuancheng Wang, Zhizheng Wu, Kai Chen*

	 · ([foleycrafter](https://github.com/open-mmlab/foleycrafter) - open-mmlab) ![Star](https://img.shields.io/github/stars/open-mmlab/foleycrafter.svg?style=social&label=Star)
- **LAFMA: A Latent Flow Matching Model for Text-to-Audio Generation**, `arXiv, 2406.08203`, [arxiv](http://arxiv.org/abs/2406.08203v1), [pdf](http://arxiv.org/pdf/2406.08203v1.pdf), cication: [**-1**](None)

	 *Wenhao Guan, Kaidi Wang, Wangjin Zhou, Yang Wang, Feng Deng, Hui Wang, Lin Li, Qingyang Hong, Yong Qin*
- **SEE-2-SOUND: Zero-Shot Spatial Environment-to-Spatial Sound**, `arXiv, 2406.06612`, [arxiv](http://arxiv.org/abs/2406.06612v1), [pdf](http://arxiv.org/pdf/2406.06612v1.pdf), cication: [**-1**](None)

	 *Rishit Dagli, Shivesh Prakash, Robert Wu, Houman Khosravani* · ([see2sound.github](https://see2sound.github.io/)) · ([see2sound](https://github.com/see2sound/see2sound) - see2sound) ![Star](https://img.shields.io/github/stars/see2sound/see2sound.svg?style=social&label=Star)
- **Creative Text-to-Audio Generation via Synthesizer Programming**, `arXiv, 2406.00294`, [arxiv](http://arxiv.org/abs/2406.00294v1), [pdf](http://arxiv.org/pdf/2406.00294v1.pdf), cication: [**-1**](None)

	 *Manuel Cherep, Nikhil Singh, Jessica Shand*
- **AudioLCM: Text-to-Audio Generation with Latent Consistency Models**, `arXiv, 2406.00356`, [arxiv](http://arxiv.org/abs/2406.00356v1), [pdf](http://arxiv.org/pdf/2406.00356v1.pdf), cication: [**-1**](None)

	 *Huadai Liu, Rongjie Huang, Yang Liu, Hengyuan Cao, Jialei Wang, Xize Cheng, Siqi Zheng, Zhou Zhao*
- [**stable-audio-open-1.0**](https://huggingface.co/stabilityai/stable-audio-open-1.0) - stabilityai 🤗
- **SoundCTM: Uniting Score-based and Consistency Models for Text-to-Sound
  Generation**, `arXiv, 2405.18503`, [arxiv](http://arxiv.org/abs/2405.18503v1), [pdf](http://arxiv.org/pdf/2405.18503v1.pdf), cication: [**-1**](None)

	 *Koichi Saito, Dongjun Kim, Takashi Shibuya, Chieh-Hsin Lai, Zhi Zhong, Yuhta Takida, Yuki Mitsufuji*
- **Visual Echoes: A Simple Unified Transformer for Audio-Visual Generation**, `arXiv, 2405.14598`, [arxiv](http://arxiv.org/abs/2405.14598v1), [pdf](http://arxiv.org/pdf/2405.14598v1.pdf), cication: [**-1**](None)

	 *Shiqi Yang, Zhi Zhong, Mengjie Zhao, Shusuke Takahashi, Masato Ishii, Takashi Shibuya, Yuki Mitsufuji* · ([docs.google](https://docs.google.com/presentation/d/1ZtC0SeblKkut4XJcRaDsSTuCRIXB3ypxmSi7HTY3IyQ))
- **Images that Sound: Composing Images and Sounds on a Single Canvas**, `arXiv, 2405.12221`, [arxiv](http://arxiv.org/abs/2405.12221v1), [pdf](http://arxiv.org/pdf/2405.12221v1.pdf), cication: [**-1**](None)

	 *Ziyang Chen, Daniel Geng, Andrew Owens* · ([ificl.github](https://ificl.github.io/images-that-sound/)) · ([images-that-sound](https://github.com/IFICL/images-that-sound) - IFICL) ![Star](https://img.shields.io/github/stars/IFICL/images-that-sound.svg?style=social&label=Star)
- **Lumina-T2X: Transforming Text into Any Modality, Resolution, and
  Duration via Flow-based Large Diffusion Transformers**, `arXiv, 2405.05945`, [arxiv](http://arxiv.org/abs/2405.05945v1), [pdf](http://arxiv.org/pdf/2405.05945v1.pdf), cication: [**-1**](None)

	 *Peng Gao, Le Zhuo, Ziyi Lin, Chris Liu, Junsong Chen, Ruoyi Du, Enze Xie, Xu Luo, Longtian Qiu, Yuhang Zhang* · ([Lumina-T2X](https://github.com/Alpha-VLLM/Lumina-T2X?tab=readme-ov-file) - Alpha-VLLM) ![Star](https://img.shields.io/github/stars/Alpha-VLLM/Lumina-T2X.svg?style=social&label=Star)
- [**WavCraft**](https://github.com/JinhuaLiang/WavCraft/blob/main) - JinhuaLiang ![Star](https://img.shields.io/github/stars/JinhuaLiang/WavCraft.svg?style=social&label=Star)

	 *Official repo for WavCraft, an AI agent for audio creation and editing*
- **Tango 2: Aligning Diffusion-based Text-to-Audio Generations through
  Direct Preference Optimization**, `arXiv, 2404.09956`, [arxiv](http://arxiv.org/abs/2404.09956v2), [pdf](http://arxiv.org/pdf/2404.09956v2.pdf), cication: [**-1**](None)

	 *Navonil Majumder, Chia-Yu Hung, Deepanway Ghosal, Wei-Ning Hsu, Rada Mihalcea, Soujanya Poria*

	 · ([tango](https://github.com/declare-lab/tango) - declare-lab) ![Star](https://img.shields.io/github/stars/declare-lab/tango.svg?style=social&label=Star)
- **Zero-Shot Unsupervised and Text-Based Audio Editing Using DDPM Inversion**, `arXiv, 2402.10009`, [arxiv](http://arxiv.org/abs/2402.10009v1), [pdf](http://arxiv.org/pdf/2402.10009v1.pdf), cication: [**-1**](None)

	 *Hila Manor, Tomer Michaeli* · ([AudioEditing](https://github.com/hilamanor/AudioEditing) - hilamanor) ![Star](https://img.shields.io/github/stars/hilamanor/AudioEditing.svg?style=social&label=Star)
- **Fast Timing-Conditioned Latent Audio Diffusion**, `arXiv, 2402.04825`, [arxiv](http://arxiv.org/abs/2402.04825v2), [pdf](http://arxiv.org/pdf/2402.04825v2.pdf), cication: [**1**](https://scholar.google.com/scholar?cites=5599278197106168575&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Zach Evans, CJ Carr, Josiah Taylor, Scott H. Hawley, Jordi Pons*

	 · ([stable-audio-tools](https://github.com/Stability-AI/stable-audio-tools) - Stability-AI) ![Star](https://img.shields.io/github/stars/Stability-AI/stable-audio-tools.svg?style=social&label=Star) · ([stability-ai.github](https://stability-ai.github.io/stable-audio-demo))
- **Natural language guidance of high-fidelity text-to-speech with synthetic
  annotations**, `arXiv, 2402.01912`, [arxiv](http://arxiv.org/abs/2402.01912v1), [pdf](http://arxiv.org/pdf/2402.01912v1.pdf), cication: [**-1**](None)

	 *Dan Lyth, Simon King* · ([text-description-to-speech](https://www.text-description-to-speech.com/))

	 · ([parler-tts](https://github.com/huggingface/parler-tts?tab=readme-ov-file) - huggingface) ![Star](https://img.shields.io/github/stars/huggingface/parler-tts.svg?style=social&label=Star)
- **BATON: Aligning Text-to-Audio Model with Human Preference Feedback**, `arXiv, 2402.00744`, [arxiv](http://arxiv.org/abs/2402.00744v1), [pdf](http://arxiv.org/pdf/2402.00744v1.pdf), cication: [**-1**](None)

	 *Huan Liao, Haonan Han, Kai Yang, Tianjiao Du, Rui Yang, Zunnan Xu, Qinmei Xu, Jingquan Liu, Jiasheng Lu, Xiu Li* · ([baton2024.github](https://baton2024.github.io/))
- **SonicVisionLM: Playing Sound with Vision Language Models**, `arXiv, 2401.04394`, [arxiv](http://arxiv.org/abs/2401.04394v2), [pdf](http://arxiv.org/pdf/2401.04394v2.pdf), cication: [**-1**](None)

	 *Zhifeng Xie, Shengye Yu, Qile He, Mengtian Li* · ([yusiissy.github](https://yusiissy.github.io/SonicVisionLM.github.io/))
- **Masked Audio Generation using a Single Non-Autoregressive Transformer**, `arXiv, 2401.04577`, [arxiv](http://arxiv.org/abs/2401.04577v1), [pdf](http://arxiv.org/pdf/2401.04577v1.pdf), cication: [**-1**](None)

	 *Alon Ziv, Itai Gat, Gael Le Lan, Tal Remez, Felix Kreuk, Alexandre Défossez, Jade Copet, Gabriel Synnaeve, Yossi Adi* · ([pages.cs.huji.ac](https://pages.cs.huji.ac.il/adiyoss-lab/MAGNeT/))

- [**seamless_communication**](https://github.com/facebookresearch/seamless_communication/tree/main) - facebookresearch ![Star](https://img.shields.io/github/stars/facebookresearch/seamless_communication.svg?style=social&label=Star)

	 *Foundational Models for State-of-the-Art Speech and Text Translation* · ([huggingface](https://huggingface.co/facebook/seamless-expressive))
- **Audiobox: Unified Audio Generation with Natural Language Prompts**, `arXiv, 2312.15821`, [arxiv](http://arxiv.org/abs/2312.15821v1), [pdf](http://arxiv.org/pdf/2312.15821v1.pdf), cication: [**-1**](None)

	 *Apoorv Vyas, Bowen Shi, Matthew Le, Andros Tjandra, Yi-Chiao Wu, Baishan Guo, Jiemin Zhang, Xinyue Zhang, Robert Adkins, William Ngan* · ([ai.meta](https://ai.meta.com/research/publications/audiobox-unified-audio-generation-with-natural-language-prompts/))

	 · ([ai.meta](https://ai.meta.com/blog/audiobox-generating-audio-voice-natural-language-prompts/?utm_source=twitter&utm_medium=organic_social&utm_campaign=fair10&utm_content=thread))
- **EDMSound: Spectrogram Based Diffusion Models for Efficient and
  High-Quality Audio Synthesis**, `arXiv, 2311.08667`, [arxiv](http://arxiv.org/abs/2311.08667v2), [pdf](http://arxiv.org/pdf/2311.08667v2.pdf), cication: [**-1**](None)

	 *Ge Zhu, Yutong Wen, Marc-André Carbonneau, Zhiyao Duan* · ([agentcooper2002.github](https://agentcooper2002.github.io/EDMSound/))
- **On The Open Prompt Challenge In Conditional Audio Generation**, `arXiv, 2311.00897`, [arxiv](http://arxiv.org/abs/2311.00897v1), [pdf](http://arxiv.org/pdf/2311.00897v1.pdf), cication: [**-1**](None)

	 *Ernie Chang, Sidd Srinivasan, Mahi Luthra, Pin-Jie Lin, Varun Nagaraja, Forrest Iandola, Zechun Liu, Zhaoheng Ni, Changsheng Zhao, Yangyang Shi*
- **In-Context Prompt Editing For Conditional Audio Generation**, `arXiv, 2311.00895`, [arxiv](http://arxiv.org/abs/2311.00895v1), [pdf](http://arxiv.org/pdf/2311.00895v1.pdf), cication: [**-1**](None)

	 *Ernie Chang, Pin-Jie Lin, Yang Li, Sidd Srinivasan, Gael Le Lan, David Kant, Yangyang Shi, Forrest Iandola, Vikas Chandra*
- **Spoken Question Answering and Speech Continuation Using
  Spectrogram-Powered LLM**, `arXiv, 2305.15255`, [arxiv](http://arxiv.org/abs/2305.15255v3), [pdf](http://arxiv.org/pdf/2305.15255v3.pdf), cication: [**-1**](None)

	 *Eliya Nachmani, Alon Levkovitch, Roy Hirsch, Julian Salazar, Chulayuth Asawaroengchai, Soroosh Mariooryad, Ehud Rivlin, RJ Skerry-Ryan, Michelle Tadmor Ramanovich*
- **Audio Generation with Multiple Conditional Diffusion Model**, `arXiv, 2308.11940`, [arxiv](http://arxiv.org/abs/2308.11940v4), [pdf](http://arxiv.org/pdf/2308.11940v4.pdf), cication: [**-1**](None)

	 *Zhifang Guo, Jianguo Mao, Rui Tao, Long Yan, Kazushige Ouchi, Hong Liu, Xiangdong Wang*
- **UniAudio: An Audio Foundation Model Toward Universal Audio Generation**, `arXiv, 2310.00704`, [arxiv](http://arxiv.org/abs/2310.00704v5), [pdf](http://arxiv.org/pdf/2310.00704v5.pdf), cication: [**-1**](None)

	 *Dongchao Yang, Jinchuan Tian, Xu Tan, Rongjie Huang, Songxiang Liu, Xuankai Chang, Jiatong Shi, Sheng Zhao, Jiang Bian, Xixin Wu* · ([UniAudio](https://github.com/yangdongchao/UniAudio) - yangdongchao) ![Star](https://img.shields.io/github/stars/yangdongchao/UniAudio.svg?style=social&label=Star)
- **FoleyGen: Visually-Guided Audio Generation**, `arXiv, 2309.10537`, [arxiv](http://arxiv.org/abs/2309.10537v1), [pdf](http://arxiv.org/pdf/2309.10537v1.pdf), cication: [**-1**](None)

	 *Xinhao Mei, Varun Nagaraja, Gael Le Lan, Zhaoheng Ni, Ernie Chang, Yangyang Shi, Vikas Chandra*
- **Enhance audio generation controllability through representation
  similarity regularization**, `arXiv, 2309.08773`, [arxiv](http://arxiv.org/abs/2309.08773v1), [pdf](http://arxiv.org/pdf/2309.08773v1.pdf), cication: [**-1**](None)

	 *Yangyang Shi, Gael Le Lan, Varun Nagaraja, Zhaoheng Ni, Xinhao Mei, Ernie Chang, Forrest Iandola, Yang Liu, Vikas Chandra*
- **Retrieval-Augmented Text-to-Audio Generation**, `arXiv, 2309.08051`, [arxiv](http://arxiv.org/abs/2309.08051v2), [pdf](http://arxiv.org/pdf/2309.08051v2.pdf), cication: [**-1**](None)

	 *Yi Yuan, Haohe Liu, Xubo Liu, Qiushi Huang, Mark D. Plumbley, Wenwu Wang*
- **AudioLDM 2: Learning Holistic Audio Generation with Self-supervised
  Pretraining**, `arXiv, 2308.05734`, [arxiv](http://arxiv.org/abs/2308.05734v2), [pdf](http://arxiv.org/pdf/2308.05734v2.pdf), cication: [**-1**](None)

	 *Haohe Liu, Qiao Tian, Yi Yuan, Xubo Liu, Xinhao Mei, Qiuqiang Kong, Yuping Wang, Wenwu Wang, Yuxuan Wang, Mark D. Plumbley* · ([AudioLDM2](https://github.com/haoheliu/AudioLDM2) - haoheliu) ![Star](https://img.shields.io/github/stars/haoheliu/AudioLDM2.svg?style=social&label=Star)
- **From Discrete Tokens to High-Fidelity Audio Using Multi-Band Diffusion**, `arXiv, 2308.02560`, [arxiv](http://arxiv.org/abs/2308.02560v2), [pdf](http://arxiv.org/pdf/2308.02560v2.pdf), cication: [**-1**](None)

	 *Robin San Roman, Yossi Adi, Antoine Deleforge, Romain Serizel, Gabriel Synnaeve, Alexandre Défossez*
- **WavJourney: Compositional Audio Creation with Large Language Models**, `arXiv, 2307.14335`, [arxiv](http://arxiv.org/abs/2307.14335v2), [pdf](http://arxiv.org/pdf/2307.14335v2.pdf), cication: [**-1**](None)

	 *Xubo Liu, Zhongkai Zhu, Haohe Liu, Yi Yuan, Meng Cui, Qiushi Huang, Jinhua Liang, Yin Cao, Qiuqiang Kong, Mark D. Plumbley* · ([WavJourney](https://github.com/Audio-AGI/WavJourney) - Audio-AGI) ![Star](https://img.shields.io/github/stars/Audio-AGI/WavJourney.svg?style=social&label=Star)
- [Recent developments in Generative AI for Audio](https://www.assemblyai.com/blog/recent-developments-in-generative-ai-for-audio/)
- **CLIPSonic: Text-to-Audio Synthesis with Unlabeled Videos and Pretrained
  Language-Vision Models**, `arXiv, 2306.09635`, [arxiv](http://arxiv.org/abs/2306.09635v2), [pdf](http://arxiv.org/pdf/2306.09635v2.pdf), cication: [**-1**](None)

	 *Hao-Wen Dong, Xiaoyu Liu, Jordi Pons, Gautam Bhattacharya, Santiago Pascual, Joan Serrà, Taylor Berg-Kirkpatrick, Julian McAuley*
- [AudioLDM, a text-to-audio model is now available in the 🧨 Diffusers library](https://colab.research.google.com/github/sanchit-gandhi/notebooks/blob/main/AudioLDM.ipynb#scrollTo=3307b8fc-c20c-4622-9b1b-9847eeb50065)
- **AudioLM: a Language Modeling Approach to Audio Generation**, `arXiv, 2209.03143`, [arxiv](http://arxiv.org/abs/2209.03143v2), [pdf](http://arxiv.org/pdf/2209.03143v2.pdf), cication: [**-1**](None)

	 *Zalán Borsos, Raphaël Marinier, Damien Vincent, Eugene Kharitonov, Olivier Pietquin, Matt Sharifi, Dominik Roblek, Olivier Teboul, David Grangier, Marco Tagliasacchi*
- **Auffusion: Leveraging the Power of Diffusion and Large Language Models
  for Text-to-Audio Generation**, `arXiv, 2401.01044`, [arxiv](http://arxiv.org/abs/2401.01044v1), [pdf](http://arxiv.org/pdf/2401.01044v1.pdf), cication: [**-1**](None)

	 *Jinlong Xue, Yayue Deng, Yingming Gao, Ya Li* · ([auffusion.github](https://auffusion.github.io/)) · ([Auffusion](https://github.com/happylittlecat2333/Auffusion) - happylittlecat2333) ![Star](https://img.shields.io/github/stars/happylittlecat2333/Auffusion.svg?style=social&label=Star)
- **AudioPaLM: A Large Language Model That Can Speak and Listen**, `arXiv, 2306.12925`, [arxiv](http://arxiv.org/abs/2306.12925v1), [pdf](http://arxiv.org/pdf/2306.12925v1.pdf), cication: [**-1**](None)

	 *Paul K. Rubenstein, Chulayuth Asawaroengchai, Duc Dung Nguyen, Ankur Bapna, Zalán Borsos, Félix de Chaumont Quitry, Peter Chen, Dalia El Badawy, Wei Han, Eugene Kharitonov*
    - [AudioPaLM](https://google-research.github.io/seanet/audiopalm/examples/)
![](https://google-research.github.io/seanet/audiopalm/examples/fig1.svg)
- **Make-An-Audio 2: Temporal-Enhanced Text-to-Audio Generation**, `arXiv, 2305.18474`, [arxiv](http://arxiv.org/abs/2305.18474v1), [pdf](http://arxiv.org/pdf/2305.18474v1.pdf), cication: [**-1**](None)

	 *Jiawei Huang, Yi Ren, Rongjie Huang, Dongchao Yang, Zhenhui Ye, Chen Zhang, Jinglin Liu, Xiang Yin, Zejun Ma, Zhou Zhao*
- [**AudioGPT**](https://github.com/AIGC-Audio/AudioGPT) - AIGC-Audio ![Star](https://img.shields.io/github/stars/AIGC-Audio/AudioGPT.svg?style=social&label=Star)

	 *AudioGPT: Understanding and Generating Speech, Music, Sound, and Talking Head*

- **Make-An-Audio: Text-To-Audio Generation with Prompt-Enhanced Diffusion
  Models**, `arXiv, 2301.12661`, [arxiv](http://arxiv.org/abs/2301.12661v1), [pdf](http://arxiv.org/pdf/2301.12661v1.pdf), cication: [**-1**](None)

	 *Rongjie Huang, Jiawei Huang, Dongchao Yang, Yi Ren, Luping Liu, Mingze Li, Zhenhui Ye, Jinglin Liu, Xiang Yin, Zhou Zhao*
- [Make-An-Audio: Text-To-Audio Generation with Prompt-Enhanced Diffusion Models](https://text-to-audio.github.io/)
- **AudioLM: a Language Modeling Approach to Audio Generation**, `arXiv, 2209.03143`, [arxiv](http://arxiv.org/abs/2209.03143v2), [pdf](http://arxiv.org/pdf/2209.03143v2.pdf), cication: [**-1**](None)

	 *Zalán Borsos, Raphaël Marinier, Damien Vincent, Eugene Kharitonov, Olivier Pietquin, Matt Sharifi, Dominik Roblek, Olivier Teboul, David Grangier, Marco Tagliasacchi*

- [AudioLM](https://google-research.github.io/seanet/audiolm/examples/)
    - [GitHub - lucidrains/audiolm-pytorch: Implementation of AudioLM, a SOTA Language Modeling Approach to Audio Generation out of Google Research, in Pytorch](https://github.com/lucidrains/audiolm-pytorch)

## Speech Generation
- **Self-Supervised Audio-Visual Soundscape Stylization**, `arXiv, 2409.14340`, [arxiv](http://arxiv.org/abs/2409.14340v1), [pdf](http://arxiv.org/pdf/2409.14340v1.pdf), cication: [**-1**](None)

	 *Tingle Li, Renhao Wang, Po-Yao Huang, Andrew Owens, Gopala Anumanchipalli* · ([avsoundscape](https://github.com/Tinglok/avsoundscape) - Tinglok) ![Star](https://img.shields.io/github/stars/Tinglok/avsoundscape.svg?style=social&label=Star) · ([tinglok.netlify](https://tinglok.netlify.app/files/avsoundscape/))
- **VoxInstruct: Expressive Human Instruction-to-Speech Generation with
  Unified Multilingual Codec Language Modelling**, `arXiv, 2408.15676`, [arxiv](http://arxiv.org/abs/2408.15676v1), [pdf](http://arxiv.org/pdf/2408.15676v1.pdf), cication: [**-1**](None)

	 *Yixuan Zhou, Xiaoyu Qin, Zeyu Jin, Shuoyi Zhou, Shun Lei, Songtao Zhou, Zhiyong Wu, Jia Jia* · ([VoxInstruct](https://github.com/thuhcsi/VoxInstruct) - thuhcsi) ![Star](https://img.shields.io/github/stars/thuhcsi/VoxInstruct.svg?style=social&label=Star) · ([voxinstruct.github](https://voxinstruct.github.io/VoxInstruct/))
- **On the Semantic Latent Space of Diffusion-Based Text-to-Speech Models**, `arXiv, 2402.12423`, [arxiv](http://arxiv.org/abs/2402.12423v2), [pdf](http://arxiv.org/pdf/2402.12423v2.pdf), cication: [**1**](https://scholar.google.com/scholar?cites=6873525485540791679&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Miri Varshavsky-Hassid, Roy Hirsch, Regev Cohen, Tomer Golany, Daniel Freedman, Ehud Rivlin* · ([latent-analysis-grad-tts.github](https://latent-analysis-grad-tts.github.io/speech-samples/))
- **Speech Editing -- a Summary**, `arXiv, 2407.17172`, [arxiv](http://arxiv.org/abs/2407.17172v1), [pdf](http://arxiv.org/pdf/2407.17172v1.pdf), cication: [**-1**](None)

	 *Tobias Kässmann, Yining Liu, Danni Liu*
- [Fetching Title#k8h1](https://instructspeech.github.io/)
- **CoVoMix: Advancing Zero-Shot Speech Generation for Human-like
  Multi-talker Conversations**, `arXiv, 2404.06690`, [arxiv](http://arxiv.org/abs/2404.06690v1), [pdf](http://arxiv.org/pdf/2404.06690v1.pdf), cication: [**-1**](None)

	 *Leying Zhang, Yao Qian, Long Zhou, Shujie Liu, Dongmei Wang, Xiaofei Wang, Midia Yousefi, Yanmin Qian, Jinyu Li, Lei He* · ([microsoft](https://www.microsoft.com/en-us/research/project/covomix/))
- **SpiRit-LM: Interleaved Spoken and Written Language Model**, `arXiv, 2402.05755`, [arxiv](http://arxiv.org/abs/2402.05755v1), [pdf](http://arxiv.org/pdf/2402.05755v1.pdf), cication: [**2**](https://scholar.google.com/scholar?cites=7368374930715826231&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Tu Anh Nguyen, Benjamin Muller, Bokai Yu, Marta R. Costa-jussa, Maha Elbayad, Sravya Popuri, Paul-Ambroise Duquenne, Robin Algayres, Ruslan Mavlyutov, Itai Gat*

	 · ([spiritlm](https://github.com/facebookresearch/spiritlm) - facebookresearch) ![Star](https://img.shields.io/github/stars/facebookresearch/spiritlm.svg?style=social&label=Star)
- **AnyGPT: Unified Multimodal LLM with Discrete Sequence Modeling**, `arXiv, 2402.12226`, [arxiv](http://arxiv.org/abs/2402.12226v3), [pdf](http://arxiv.org/pdf/2402.12226v3.pdf), cication: [**-1**](None)

	 *Jun Zhan, Junqi Dai, Jiasheng Ye, Yunhua Zhou, Dong Zhang, Zhigeng Liu, Xin Zhang, Ruibin Yuan, Ge Zhang, Linyang Li* · ([SpeechGPT](https://github.com/0nutation/SpeechGPT) - 0nutation) ![Star](https://img.shields.io/github/stars/0nutation/SpeechGPT.svg?style=social&label=Star)
- [A neural speech decoding framework leveraging deep learning and speech synthesis | Nature Machine Intelligence](https://www.nature.com/articles/s42256-024-00824-8)
- **WavLLM: Towards Robust and Adaptive Speech Large Language Model**, `arXiv, 2404.00656`, [arxiv](http://arxiv.org/abs/2404.00656v1), [pdf](http://arxiv.org/pdf/2404.00656v1.pdf), cication: [**-1**](None)

	 *Shujie Hu, Long Zhou, Shujie Liu, Sanyuan Chen, Hongkun Hao, Jing Pan, Xunying Liu, Jinyu Li, Sunit Sivasankaran, Linquan Liu*

	 · ([aka](http://aka.ms/wavllm))
- **Making Flow-Matching-Based Zero-Shot Text-to-Speech Laugh as You Like**, `arXiv, 2402.07383`, [arxiv](http://arxiv.org/abs/2402.07383v1), [pdf](http://arxiv.org/pdf/2402.07383v1.pdf), cication: [**-1**](None)

	 *Naoyuki Kanda, Xiaofei Wang, Sefik Emre Eskimez, Manthan Thakker, Hemin Yang, Zirun Zhu, Min Tang, Canrun Li, Steven Tsai, Zhen Xiao* · ([aka](https://aka.ms/elate/))
- **SpeechGPT-Gen: Scaling Chain-of-Information Speech Generation**, `arXiv, 2401.13527`, [arxiv](http://arxiv.org/abs/2401.13527v2), [pdf](http://arxiv.org/pdf/2401.13527v2.pdf), cication: [**-1**](None)

	 *Dong Zhang, Xin Zhang, Jun Zhan, Shimin Li, Yaqian Zhou, Xipeng Qiu*
- **SpeechPrompt: An Exploration of Prompt Tuning on Generative Spoken
  Language Model for Speech Processing Tasks**, `arXiv, 2203.16773`, [arxiv](http://arxiv.org/abs/2203.16773v3), [pdf](http://arxiv.org/pdf/2203.16773v3.pdf), cication: [**-1**](None)

	 *Kai-Wei Chang, Wei-Cheng Tseng, Shang-Wen Li, Hung-yi Lee*
- **SpeechPrompt v2: Prompt Tuning for Speech Classification Tasks**, `arXiv, 2303.00733`, [arxiv](http://arxiv.org/abs/2303.00733v1), [pdf](http://arxiv.org/pdf/2303.00733v1.pdf), cication: [**-1**](None)

	 *Kai-Wei Chang, Yu-Kai Wang, Hua Shen, Iu-thing Kang, Wei-Cheng Tseng, Shang-Wen Li, Hung-yi Lee*
- [Voicebox: Text-Guided Multilingual Universal Speech Generation at Scale - Meta Research](https://research.facebook.com/publications/voicebox-text-guided-multilingual-universal-speech-generation-at-scale/)

	 · ([jiqizhixin](https://www.jiqizhixin.com/articles/2023-06-18)) · ([ai.facebook](https://ai.facebook.com/blog/voicebox-generative-ai-model-speech/))

	 · ([voicebox.metademolab](https://voicebox.metademolab.com/zs_tts.html))
- **SpeechGen: Unlocking the Generative Power of Speech Language Models with
  Prompts**, `arXiv, 2306.02207`, [arxiv](http://arxiv.org/abs/2306.02207v3), [pdf](http://arxiv.org/pdf/2306.02207v3.pdf), cication: [**-1**](None)

	 *Haibin Wu, Kai-Wei Chang, Yuan-Kuei Wu, Hung-yi Lee*
- [SpeechPrompt](https://ga642381.github.io/SpeechPrompt/speechgen.html
	 · ([SpeechGen](https://github.com/ga642381/SpeechGen) - ga642381) ![Star](https://img.shields.io/github/stars/ga642381/SpeechGen.svg?style=social&label=Star)

- **Textually Pretrained Speech Language Models**, `arXiv, 2305.13009`, [arxiv](http://arxiv.org/abs/2305.13009v3), [pdf](http://arxiv.org/pdf/2305.13009v3.pdf), cication: [**-1**](None)

	 *Michael Hassid, Tal Remez, Tu Anh Nguyen, Itai Gat, Alexis Conneau, Felix Kreuk, Jade Copet, Alexandre Defossez, Gabriel Synnaeve, Emmanuel Dupoux*
- [Textually Pretrained Speech Language Models](https://pages.cs.huji.ac.il/adiyoss-lab/twist/)
- **AudioPaLM: A Large Language Model That Can Speak and Listen**, `arXiv, 2306.12925`, [arxiv](http://arxiv.org/abs/2306.12925v1), [pdf](http://arxiv.org/pdf/2306.12925v1.pdf), cication: [**-1**](None)

	 *Paul K. Rubenstein, Chulayuth Asawaroengchai, Duc Dung Nguyen, Ankur Bapna, Zalán Borsos, Félix de Chaumont Quitry, Peter Chen, Dalia El Badawy, Wei Han, Eugene Kharitonov*
- **SpeechGPT: Empowering Large Language Models with Intrinsic Cross-Modal
  Conversational Abilities**, `arXiv, 2305.11000`, [arxiv](http://arxiv.org/abs/2305.11000v2), [pdf](http://arxiv.org/pdf/2305.11000v2.pdf), cication: [**-1**](None)

	 *Dong Zhang, Shimin Li, Xin Zhang, Jun Zhan, Pengyu Wang, Yaqian Zhou, Xipeng Qiu*
    - [SpeechGPT](https://0nutation.github.io/SpeechGPT.github.io/)
    - [GitHub - 0nutation/SpeechGPT: SpeechGPT: Empowering Large Language Models with Intrinsic Cross-Modal Conversational Abilities.](https://github.com/0nutation/SpeechGPT)

- **Diff-Foley: Synchronized Video-to-Audio Synthesis with Latent Diffusion
  Models**, `NeurIPS, 2024`, [arxiv](http://arxiv.org/abs/2306.17203v1), [pdf](http://arxiv.org/pdf/2306.17203v1.pdf), cication: [**4**](https://scholar.google.com/scholar?cites=4465076046329977447&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Simian Luo, Chuanhao Yan, Chenxu Hu, Hang Zhao* · ([diff-foley.github](https://diff-foley.github.io/)) · ([Diff-Foley](https://github.com/luosiallen/Diff-Foley) - luosiallen) ![Star](https://img.shields.io/github/stars/luosiallen/Diff-Foley.svg?style=social&label=Star)
- [**bark**](https://github.com/suno-ai/bark) - suno-ai ![Star](https://img.shields.io/github/stars/suno-ai/bark.svg?style=social&label=Star)

	 *🔊 Text-Prompted Generative Audio Model*

## Audio Understanding 
- **Towards Diverse and Efficient Audio Captioning via Diffusion Models**, `arXiv, 2409.09401`, [arxiv](http://arxiv.org/abs/2409.09401v1), [pdf](http://arxiv.org/pdf/2409.09401v1.pdf), cication: [**-1**](None)

	 *Manjie Xu, Chenxing Li, Xinyi Tu, Yong Ren, Ruibo Fu, Wei Liang, Dong Yu*
- **WHISMA: A Speech-LLM to Perform Zero-shot Spoken Language Understanding**, `arXiv, 2408.16423`, [arxiv](http://arxiv.org/abs/2408.16423v1), [pdf](http://arxiv.org/pdf/2408.16423v1.pdf), cication: [**-1**](None)

	 *Mohan Li, Cong-Thanh Do, Simon Keizer, Youmna Farag, Svetlana Stoyanchev, Rama Doddipatla*
- **SpeechPrompt: Prompting Speech Language Models for Speech Processing
  Tasks**, `arXiv, 2408.13040`, [arxiv](http://arxiv.org/abs/2408.13040v1), [pdf](http://arxiv.org/pdf/2408.13040v1.pdf), cication: [**-1**](None)

	 *Kai-Wei Chang, Haibin Wu, Yu-Kai Wang, Yuan-Kuei Wu, Hua Shen, Wei-Cheng Tseng, Iu-thing Kang, Shang-Wen Li, Hung-yi Lee*
- **MooER: LLM-based Speech Recognition and Translation Models from Moore
  Threads**, `arXiv, 2408.05101`, [arxiv](http://arxiv.org/abs/2408.05101v1), [pdf](http://arxiv.org/pdf/2408.05101v1.pdf), cication: [**-1**](None)

	 *Junhao Xu, Zhenlin Liang, Yi Liu, Yichao Hu, Jian Li, Yajun Zheng, Meng Cai, Hua Wang* · ([mooer](https://github.com/moorethreads/mooer) - moorethreads) ![Star](https://img.shields.io/github/stars/moorethreads/mooer.svg?style=social&label=Star)
- [Revisiting Voice Large Language Models as Scalable Multi-Lingual and Multi-Task Learners](https://aclanthology.org/2024.acl-long.589.pdf)

	 · ([m-voice.github](https://m-voice.github.io/))
- **Sentence-wise Speech Summarization: Task, Datasets, and End-to-End
  Modeling with LM Knowledge Distillation**, `arXiv, 2408.00205`, [arxiv](http://arxiv.org/abs/2408.00205v1), [pdf](http://arxiv.org/pdf/2408.00205v1.pdf), cication: [**-1**](None)

	 *Kohei Matsuura, Takanori Ashihara, Takafumi Moriya, Masato Mimura, Takatomo Kano, Atsunori Ogawa, Marc Delcroix* · ([huggingface](https://huggingface.co/datasets/komats/mega-ssum))
- [DiVA (Distilled Voice Assistant)](https://diva-audio.github.io/)

	 · ([levanter](https://github.com/Helw150/levanter/blob/will/distill/src/levanter/models/via.py) - Helw150) ![Star](https://img.shields.io/github/stars/Helw150/levanter.svg?style=social&label=Star) · ([huggingface](https://huggingface.co/WillHeld/DiVA-llama-3-v0-8b))
- **Qwen2-Audio Technical Report**, `arXiv, 2407.10759`, [arxiv](http://arxiv.org/abs/2407.10759v1), [pdf](http://arxiv.org/pdf/2407.10759v1.pdf), cication: [**-1**](None)

	 *Yunfei Chu, Jin Xu, Qian Yang, Haojie Wei, Xipin Wei, Zhifang Guo, Yichong Leng, Yuanjun Lv, Jinzheng He, Junyang Lin*

	 · ([Qwen2-Audio](https://github.com/QwenLM/Qwen2-Audio) - QwenLM) ![Star](https://img.shields.io/github/stars/QwenLM/Qwen2-Audio.svg?style=social&label=Star)

	 · ([qwenlm.github](https://qwenlm.github.io/blog/qwen2-audio/))
- **AudioBench: A Universal Benchmark for Audio Large Language Models**, `arXiv, 2406.16020`, [arxiv](http://arxiv.org/abs/2406.16020v2), [pdf](http://arxiv.org/pdf/2406.16020v2.pdf), cication: [**-1**](None)

	 *Bin Wang, Xunlong Zou, Geyu Lin, Shuo Sun, Zhuohan Liu, Wenyu Zhang, Zhengyuan Liu, AiTi Aw, Nancy F. Chen* · ([AudioBench](https://github.com/AudioLLMs/AudioBench) - AudioLLMs) ![Star](https://img.shields.io/github/stars/AudioLLMs/AudioBench.svg?style=social&label=Star)
- **Instruction Data Generation and Unsupervised Adaptation for Speech
  Language Models**, `arXiv, 2406.12946`, [arxiv](http://arxiv.org/abs/2406.12946v1), [pdf](http://arxiv.org/pdf/2406.12946v1.pdf), cication: [**-1**](None)

	 *Vahid Noroozi, Zhehuai Chen, Somshubra Majumdar, Steve Huang, Jagadeesh Balam, Boris Ginsburg*
- **GAMA: A Large Audio-Language Model with Advanced Audio Understanding and
  Complex Reasoning Abilities**, `arXiv, 2406.11768`, [arxiv](http://arxiv.org/abs/2406.11768v1), [pdf](http://arxiv.org/pdf/2406.11768v1.pdf), cication: [**-1**](None)

	 *Sreyan Ghosh, Sonal Kumar, Ashish Seth, Chandra Kiran Reddy Evuru, Utkarsh Tyagi, S Sakshi, Oriol Nieto, Ramani Duraiswami, Dinesh Manocha*
- **SpeechVerse: A Large-scale Generalizable Audio Language Model**, `arXiv, 2405.08295`, [arxiv](http://arxiv.org/abs/2405.08295v1), [pdf](http://arxiv.org/pdf/2405.08295v1.pdf), cication: [**-1**](None)

	 *Nilaksh Das, Saket Dingliwal, Srikanth Ronanki, Rohit Paturi, David Huang, Prashant Mathur, Jie Yuan, Dhanush Bekal, Xing Niu, Sai Muralidhar Jayanthi*
- **Scaling Properties of Speech Language Models**, `arXiv, 2404.00685`, [arxiv](http://arxiv.org/abs/2404.00685v1), [pdf](http://arxiv.org/pdf/2404.00685v1.pdf), cication: [**-1**](None)

	 *Santiago Cuervo, Ricard Marxer*
- **Audio Flamingo: A Novel Audio Language Model with Few-Shot Learning and
  Dialogue Abilities**, `arXiv, 2402.01831`, [arxiv](http://arxiv.org/abs/2402.01831v1), [pdf](http://arxiv.org/pdf/2402.01831v1.pdf), cication: [**-1**](None)

	 *Zhifeng Kong, Arushi Goel, Rohan Badlani, Wei Ping, Rafael Valle, Bryan Catanzaro*
- [**Qwen-Audio**](https://github.com/QwenLM/Qwen-Audio) - QwenLM ![Star](https://img.shields.io/github/stars/QwenLM/Qwen-Audio.svg?style=social&label=Star)

	 *The official repo of Qwen-Audio (通义千问-Audio) chat & pretrained large audio language model proposed by Alibaba Cloud.*
- **FLAP: Fast Language-Audio Pre-training**, `arXiv, 2311.01615`, [arxiv](http://arxiv.org/abs/2311.01615v1), [pdf](http://arxiv.org/pdf/2311.01615v1.pdf), cication: [**-1**](None)

	 *Ching-Feng Yeh, Po-Yao Huang, Vasu Sharma, Shang-Wen Li, Gargi Gosh*
- [**SALMONN**](https://github.com/bytedance/SALMONN) - bytedance ![Star](https://img.shields.io/github/stars/bytedance/SALMONN.svg?style=social&label=Star)

	 *SALMONN: Speech Audio Language Music Open Neural Network*
- **Toward Joint Language Modeling for Speech Units and Text**, `arXiv, 2310.08715`, [arxiv](http://arxiv.org/abs/2310.08715v1), [pdf](http://arxiv.org/pdf/2310.08715v1.pdf), cication: [**-1**](None)

	 *Ju-Chieh Chou, Chung-Ming Chien, Wei-Ning Hsu, Karen Livescu, Arun Babu, Alexis Conneau, Alexei Baevski, Michael Auli*
- **LLark: A Multimodal Foundation Model for Music**, `arXiv, 2310.07160`, [arxiv](http://arxiv.org/abs/2310.07160v1), [pdf](http://arxiv.org/pdf/2310.07160v1.pdf), cication: [**-1**](None)

	 *Josh Gardner, Simon Durand, Daniel Stoller, Rachel M. Bittner*
- [**seamless_communication**](https://github.com/facebookresearch/seamless_communication) - facebookresearch ![Star](https://img.shields.io/github/stars/facebookresearch/seamless_communication.svg?style=social&label=Star)

	 *Foundational Models for State-of-the-Art Speech and Text Translation* · ([seamless-m4t-colab](https://github.com/camenduru/seamless-m4t-colab) - camenduru) ![Star](https://img.shields.io/github/stars/camenduru/seamless-m4t-colab.svg?style=social&label=Star) · ([ai.meta](https://ai.meta.com/research/publications/seamless-m4t/)) · ([ai.meta](https://ai.meta.com/resources/models-and-libraries/seamless-communication-models/#seamlessm4t)) · ([seamless_communication](https://github.com/facebookresearch/seamless_communication) - facebookresearch) ![Star](https://img.shields.io/github/stars/facebookresearch/seamless_communication.svg?style=social&label=Star)
	- 首个通用语音翻译系统！[Meta重磅开源SeamlessM4T](https://mp.weixin.qq.com/s?__biz=MzI3MTA0MTk1MA==&mid=2652370902&idx=5&sn=a063f21c70247b2d02ca063323ac1351)：支持100种语言多模态翻译，附47万小时训练数据
- [**SALMONN**](https://github.com/bytedance/SALMONN/) - bytedance ![Star](https://img.shields.io/github/stars/bytedance/SALMONN.svg?style=social&label=Star)

	 *SALMONN: Speech Audio Language Music Open Neural Network*

	 · ([mp.weixin.qq](https://mp.weixin.qq.com/s?__biz=MzI3MTA0MTk1MA==&mid=2652368752&idx=2&sn=c3c4463725a2c13869d9b887c1f54b62))
- **Any-to-Any Generation via Composable Diffusion**, `arXiv, 2305.11846`, [arxiv](http://arxiv.org/abs/2305.11846v1), [pdf](http://arxiv.org/pdf/2305.11846v1.pdf), cication: [**-1**](None)

	 *Zineng Tang, Ziyi Yang, Chenguang Zhu, Michael Zeng, Mohit Bansal*
- [CoDi: Generate Anything from Anything All At Once through Composable Diffusion](https://codi-gen.github.io/)
- [**i-Code**](https://github.com/microsoft/i-Code/tree/main/i-Code-V3) - microsoft ![Star](https://img.shields.io/github/stars/microsoft/i-Code.svg?style=social&label=Star)
- **Pengi: An Audio Language Model for Audio Tasks**, `arXiv, 2305.11834`, [arxiv](http://arxiv.org/abs/2305.11834v2), [pdf](http://arxiv.org/pdf/2305.11834v2.pdf), cication: [**-1**](None)

	 *Soham Deshmukh, Benjamin Elizalde, Rita Singh, Huaming Wang*

- [**Pengi**](https://github.com/microsoft/Pengi) - microsoft ![Star](https://img.shields.io/github/stars/microsoft/Pengi.svg?style=social&label=Star)

	 *An Audio Language model for Audio Tasks*

- **Large-scale Contrastive Language-Audio Pretraining with Feature Fusion
  and Keyword-to-Caption Augmentation**, `arXiv, 2211.06687`, [arxiv](http://arxiv.org/abs/2211.06687v3), [pdf](http://arxiv.org/pdf/2211.06687v3.pdf), cication: [**-1**](None)

	 *Yusong Wu, Ke Chen, Tianyu Zhang, Yuchen Hui, Taylor Berg-Kirkpatrick, Shlomo Dubnov*

- [**CLAP**](https://github.com/LAION-AI/CLAP) - LAION-AI ![Star](https://img.shields.io/github/stars/LAION-AI/CLAP.svg?style=social&label=Star)

	 *Contrastive Language-Audio Pretraining*

- **CLAP: Learning Audio Concepts From Natural Language Supervision**, `arXiv, 2206.04769`, [arxiv](http://arxiv.org/abs/2206.04769v1), [pdf](http://arxiv.org/pdf/2206.04769v1.pdf), cication: [**-1**](None)

	 *Benjamin Elizalde, Soham Deshmukh, Mahmoud Al Ismail, Huaming Wang*

    - [GitHub - microsoft/CLAP: Learning audio concepts from natural language supervision](https://github.com/microsoft/CLAP)


## Image Generation With Audio
- **AudioToken: Adaptation of Text-Conditioned Diffusion Models for
  Audio-to-Image Generation**, `arXiv, 2305.13050`, [arxiv](http://arxiv.org/abs/2305.13050v1), [pdf](http://arxiv.org/pdf/2305.13050v1.pdf), cication: [**-1**](None)

	 *Guy Yariv, Itai Gat, Lior Wolf, Yossi Adi, Idan Schwartz*
- [Adaptation of Text-Conditioned Diffusion Models for Audio-to-Image Generation](https://pages.cs.huji.ac.il/adiyoss-lab/AudioToken/)
- [**AudioToken**](https://github.com/guyyariv/AudioToken) - guyyariv ![Star](https://img.shields.io/github/stars/guyyariv/AudioToken.svg?style=social&label=Star)

	 *This repo contains the official PyTorch implementation of Adaptation of Text-Conditioned Diffusion Models for Audio-to-Image Generation*
- **Natural Language Supervision for General-Purpose Audio Representations**, `arXiv, 2309.05767`, [arxiv](http://arxiv.org/abs/2309.05767v1), [pdf](http://arxiv.org/pdf/2309.05767v1.pdf), cication: [**-1**](None)

	 *Benjamin Elizalde, Soham Deshmukh, Huaming Wang*


## Toolkits
- [**audio-diffusion-pytorch**](https://github.com/archinetai/audio-diffusion-pytorch) - archinetai ![Star](https://img.shields.io/github/stars/archinetai/audio-diffusion-pytorch.svg?style=social&label=Star)

	 *Audio generation using diffusion models, in PyTorch.*
- [**livekit**](https://github.com/livekit/livekit) - livekit ![Star](https://img.shields.io/github/stars/livekit/livekit.svg?style=social&label=Star)

	 *End-to-end stack for WebRTC. SFU media server and SDKs.*
- [**dataspeech**](https://github.com/huggingface/dataspeech) - huggingface ![Star](https://img.shields.io/github/stars/huggingface/dataspeech.svg?style=social&label=Star)
- [**stable-audio-tools**](https://github.com/Stability-AI/stable-audio-tools) - Stability-AI ![Star](https://img.shields.io/github/stars/Stability-AI/stable-audio-tools.svg?style=social&label=Star)

	 *Generative models for conditional audio generation*


## Retrieval
- **A SOUND APPROACH: Using Large Language Models to generate audio
  descriptions for egocentric text-audio retrieval**, `arXiv, 2402.19106`, [arxiv](http://arxiv.org/abs/2402.19106v1), [pdf](http://arxiv.org/pdf/2402.19106v1.pdf), cication: [**-1**](None)

	 *Andreea-Maria Oncescu, João F. Henriques, Andrew Zisserman, Samuel Albanie, A. Sophia Koepke*

## Audio Agent
- **WavCraft: Audio Editing and Generation with Natural Language Prompts**, `arXiv, 2403.09527`, [arxiv](http://arxiv.org/abs/2403.09527v1), [pdf](http://arxiv.org/pdf/2403.09527v1.pdf), cication: [**-1**](None)

	 *Jinhua Liang, Huan Zhang, Haohe Liu, Yin Cao, Qiuqiang Kong, Xubo Liu, Wenwu Wang, Mark D. Plumbley, Huy Phan, Emmanouil Benetos*

	 · ([WavCraft](https://github.com/JinhuaLiang/WavCraft) - JinhuaLiang) ![Star](https://img.shields.io/github/stars/JinhuaLiang/WavCraft.svg?style=social&label=Star)

## Other
- [能听懂语音的ChatGPT来了：10小时录音扔进去，想问什么问什么 | 机器之心](https://www.jiqizhixin.com/articles/2023-06-02-4)


## Product
- [Fetching Title#8xc0](https://suno.com/blog/introducing-suno-scenes)
- [Generating audio for video](https://deepmind.google/discover/blog/generating-audio-for-video/)