# Awesome Audio Encoding

- [Awesome Audio Encoding](#awesome-audio-encoding)
  - [Papers and Projects](#papers-and-projects)
  - [References](#references)

## Papers and Projects 
- **Analyzing and Mitigating Inconsistency in Discrete Audio Tokens for
  Neural Codec Language Models**, `arXiv, 2409.19283`, [arxiv](http://arxiv.org/abs/2409.19283v2), [pdf](http://arxiv.org/pdf/2409.19283v2.pdf), cication: [**-1**](None)

	 *Wenrui Liu, Zhifang Guo, Jin Xu, Yuanjun Lv, Yunfei Chu, Zhou Zhao, Junyang Lin* · ([consistencyinneuralcodec.github](https://consistencyinneuralcodec.github.io/))
- **ESPnet-Codec: Comprehensive Training and Evaluation of Neural Codecs for
  Audio, Music, and Speech**, `arXiv, 2409.15897`, [arxiv](http://arxiv.org/abs/2409.15897v1), [pdf](http://arxiv.org/pdf/2409.15897v1.pdf), cication: [**2**](https://scholar.google.com/scholar?cites=17046891627356359494&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Jiatong Shi, Jinchuan Tian, Yihan Wu, Jee-weon Jung, Jia Qi Yip, Yoshiki Masuyama, William Chen, Yuning Wu, Yuxun Tang, Massa Baali*
- **MuCodec: Ultra Low-Bitrate Music Codec**, `arXiv, 2409.13216`, [arxiv](http://arxiv.org/abs/2409.13216v2), [pdf](http://arxiv.org/pdf/2409.13216v2.pdf), cication: [**-1**](None)

	 *Yaoxun Xu, Hangting Chen, Jianwei Yu, Wei Tan, Rongzhi Gu, Shun Lei, Zhiwei Lin, Zhiyong Wu* · ([xuyaoxun.github](https://xuyaoxun.github.io/MuCodec_demo/))
- **NDVQ: Robust Neural Audio Codec with Normal Distribution-Based Vector
  Quantization**, `arXiv, 2409.12717`, [arxiv](http://arxiv.org/abs/2409.12717v1), [pdf](http://arxiv.org/pdf/2409.12717v1.pdf), cication: [**-1**](None)

	 *Zhikang Niu, Sanyuan Chen, Long Zhou, Ziyang Ma, Xie Chen, Shujie Liu*
- **Speaking from Coarse to Fine: Improving Neural Codec Language Model via
  Multi-Scale Speech Coding and Generation**, `arXiv, 2409.11630`, [arxiv](http://arxiv.org/abs/2409.11630v1), [pdf](http://arxiv.org/pdf/2409.11630v1.pdf), cication: [**-1**](None)

	 *Haohan Guo, Fenglong Xie, Dongchao Yang, Xixin Wu, Helen Meng*
- **Low Frame-rate Speech Codec: a Codec Designed for Fast High-quality
  Speech LLM Training and Inference**, `arXiv, 2409.12117`, [arxiv](http://arxiv.org/abs/2409.12117v1), [pdf](http://arxiv.org/pdf/2409.12117v1.pdf), cication: [**-1**](None)

	 *Edresson Casanova, Ryan Langman, Paarth Neekhara, Shehzeen Hussain, Jason Li, Subhankar Ghosh, Ante Jukić, Sang-gil Lee*
- **Learning Source Disentanglement in Neural Audio Codec**, `arXiv, 2409.11228`, [arxiv](http://arxiv.org/abs/2409.11228v1), [pdf](http://arxiv.org/pdf/2409.11228v1.pdf), cication: [**-1**](None)

	 *Xiaoyu Bie, Xubo Liu, Gaël Richard*
- **WavTokenizer: an Efficient Acoustic Discrete Codec Tokenizer for Audio
  Language Modeling**, `arXiv, 2408.16532`, [arxiv](http://arxiv.org/abs/2408.16532v1), [pdf](http://arxiv.org/pdf/2408.16532v1.pdf), cication: [**-1**](None)

	 *Shengpeng Ji, Ziyue Jiang, Xize Cheng, Yifu Chen, Minghui Fang, Jialong Zuo, Qian Yang, Ruiqi Li, Ziang Zhang, Xiaoda Yang* · ([WavTokenizer](https://github.com/jishengpeng/WavTokenizer) - jishengpeng) ![Star](https://img.shields.io/github/stars/jishengpeng/WavTokenizer.svg?style=social&label=Star)
- **Investigating Neural Audio Codecs for Speech Language Model-Based Speech
  Generation**, `arXiv, 2409.04016`, [arxiv](http://arxiv.org/abs/2409.04016v1), [pdf](http://arxiv.org/pdf/2409.04016v1.pdf), cication: [**-1**](None)

	 *Jiaqi Li, Dongmei Wang, Xiaofei Wang, Yao Qian, Long Zhou, Shujie Liu, Midia Yousefi, Canrun Li, Chung-Hsien Tsai, Zhen Xiao*
- **Towards Robust Speech Representation Learning for Thousands of Languages**, `arXiv, 2407.00837`, [arxiv](http://arxiv.org/abs/2407.00837v2), [pdf](http://arxiv.org/pdf/2407.00837v2.pdf), cication: [**-1**](None)

	 *William Chen, Wangyou Zhang, Yifan Peng, Xinjian Li, Jinchuan Tian, Jiatong Shi, Xuankai Chang, Soumi Maiti, Karen Livescu, Shinji Watanabe*

	 · ([huggingface](https://huggingface.co/espnet/xeus))
	 · ([wanchichen.github](https://wanchichen.github.io/pdf/xeus.pdf))
- **Towards Audio Codec-based Speech Separation**, `arXiv, 2406.12434`, [arxiv](http://arxiv.org/abs/2406.12434v1), [pdf](http://arxiv.org/pdf/2406.12434v1.pdf), cication: [**-1**](None)

	 *Jia Qi Yip, Shengkui Zhao, Dianwen Ng, Eng Siong Chng, Bin Ma* · ([codecformer](https://github.com/Yip-Jia-Qi/codecformer) - Yip-Jia-Qi) ![Star](https://img.shields.io/github/stars/Yip-Jia-Qi/codecformer.svg?style=social&label=Star)
- **mHuBERT-147: A Compact Multilingual HuBERT Model**, `arXiv, 2406.06371`, [arxiv](http://arxiv.org/abs/2406.06371v2), [pdf](http://arxiv.org/pdf/2406.06371v2.pdf), cication: [**-1**](None)

	 *Marcely Zanon Boito, Vivek Iyer, Nikolaos Lagos, Laurent Besacier, Ioan Calapodescu* · ([huggingface](https://huggingface.co/utter-project/mHuBERT-147))
- **Audio Mamba: Bidirectional State Space Model for Audio Representation
  Learning**, `arXiv, 2406.03344`, [arxiv](http://arxiv.org/abs/2406.03344v1), [pdf](http://arxiv.org/pdf/2406.03344v1.pdf), cication: [**-1**](None)

	 *Mehmet Hamza Erol, Arda Senocak, Jiu Feng, Joon Son Chung*
- [**snac**](https://github.com/hubertsiuzdak/snac/) - hubertsiuzdak ![Star](https://img.shields.io/github/stars/hubertsiuzdak/snac.svg?style=social&label=Star)

	 *Multi-Scale Neural Audio Codec (SNAC) compresses audio into discrete codes at a low bitrate* · ([huggingface](https://huggingface.co/datasets/blanchon/snac_llm_parler_tts))
- **ESC: Efficient Speech Coding with Cross-Scale Residual Vector Quantized
  Transformers**, `arXiv, 2404.19441`, [arxiv](http://arxiv.org/abs/2404.19441v1), [pdf](http://arxiv.org/pdf/2404.19441v1.pdf), cication: [**-1**](None)

	 *Yuzhe Gu, Enmao Diao* · ([efficient-speech-codec](https://github.com/yzGuu830/efficient-speech-codec) - yzGuu830) ![Star](https://img.shields.io/github/stars/yzGuu830/efficient-speech-codec.svg?style=social&label=Star)
- **SemantiCodec: An Ultra Low Bitrate Semantic Audio Codec for General
  Sound**, `arXiv, 2405.00233`, [arxiv](http://arxiv.org/abs/2405.00233v1), [pdf](http://arxiv.org/pdf/2405.00233v1.pdf), cication: [**-1**](None)

	 *Haohe Liu, Xuenan Xu, Yi Yuan, Mengyue Wu, Wenwu Wang, Mark D. Plumbley* · ([haoheliu.github](https://haoheliu.github.io/SemantiCodec/))
- **PromptCodec: High-Fidelity Neural Speech Codec using Disentangled
  Representation Learning based Adaptive Feature-aware Prompt Encoders**, `arXiv, 2404.02702`, [arxiv](http://arxiv.org/abs/2404.02702v1), [pdf](http://arxiv.org/pdf/2404.02702v1.pdf), cication: [**-1**](None)

	 *Yu Pan, Lei Ma, Jianjun Zhao*
- [**Amphion**](https://github.com/open-mmlab/Amphion/blob/main/models/codec/ns3_codec/README.md) - open-mmlab ![Star](https://img.shields.io/github/stars/open-mmlab/Amphion.svg?style=social&label=Star)

	 *Speech Codec with Attribute Factorization used for NaturalSpeech 3*
- **RepCodec: A Speech Representation Codec for Speech Tokenization**, `arXiv, 2309.00169`, [arxiv](http://arxiv.org/abs/2309.00169v2), [pdf](http://arxiv.org/pdf/2309.00169v2.pdf), cication: [**3**](https://scholar.google.com/scholar?cites=6060346483384682669&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Zhichao Huang, Chutong Meng, Tom Ko*

	 · ([RepCodec](https://github.com/mct10/RepCodec) - mct10) ![Star](https://img.shields.io/github/stars/mct10/RepCodec.svg?style=social&label=Star)
- **HILCodec: High Fidelity and Lightweight Neural Audio Codec**, `arXiv, 2405.04752`, [arxiv](http://arxiv.org/abs/2405.04752v1), [pdf](http://arxiv.org/pdf/2405.04752v1.pdf), cication: [**-1**](None)

	 *Sunghwan Ahn, Beom Jun Woo, Min Hyun Han, Chanyeong Moon, Nam Soo Kim*

	 · ([hilcodec](https://github.com/aask1357/hilcodec) - aask1357) ![Star](https://img.shields.io/github/stars/aask1357/hilcodec.svg?style=social&label=Star)
- **Efficient Autoregressive Audio Modeling via Next-Scale Prediction**, `arXiv, 2408.09027`, [arxiv](http://arxiv.org/abs/2408.09027v1), [pdf](http://arxiv.org/pdf/2408.09027v1.pdf), cication: [**-1**](None)

	 *Kai Qiu, Xiang Li, Hao Chen, Jie Sun, Jinglu Wang, Zhe Lin, Marios Savvides, Bhiksha Raj* · ([AAR](https://github.com/qiuk2/AAR?tab=readme-ov-file) - qiuk2) ![Star](https://img.shields.io/github/stars/qiuk2/AAR.svg?style=social&label=Star)
- **Language-Codec: Reducing the Gaps Between Discrete Codec Representation
  and Speech Language Models**, `arXiv, 2402.12208`, [arxiv](http://arxiv.org/abs/2402.12208v2), [pdf](http://arxiv.org/pdf/2402.12208v2.pdf), cication: [**-1**](None)

	 *Shengpeng Ji, Minghui Fang, Ziyue Jiang, Rongjie Huang, Jialung Zuo, Shulei Wang, Zhou Zhao* · ([languagecodec](https://github.com/jishengpeng/languagecodec?tab=readme-ov-file) - jishengpeng) ![Star](https://img.shields.io/github/stars/jishengpeng/languagecodec.svg?style=social&label=Star) · ([languagecodec.github](https://languagecodec.github.io/))
- **Toward Joint Language Modeling for Speech Units and Text**, `arXiv, 2310.08715`, [arxiv](http://arxiv.org/abs/2310.08715v1), [pdf](http://arxiv.org/pdf/2310.08715v1.pdf), cication: [**3**](https://scholar.google.com/scholar?cites=13061955866764932417&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Ju-Chieh Chou, Chung-Ming Chien, Wei-Ning Hsu, Karen Livescu, Arun Babu, Alexis Conneau, Alexei Baevski, Michael Auli*
- **Fewer-token Neural Speech Codec with Time-invariant Codes**, `icassp 2024-2024 ieee international conference on acoustics …, 2024`, [arxiv](http://arxiv.org/abs/2310.00014v2), [pdf](http://arxiv.org/pdf/2310.00014v2.pdf), cication: [**2**](https://scholar.google.com/scholar?cites=14670162790270437734&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Yong Ren, Tao Wang, Jiangyan Yi, Le Xu, Jianhua Tao, Chuyuan Zhang, Junzuo Zhou*

	 · ([TiCodec](https://github.com/y-ren16/TiCodec) - y-ren16) ![Star](https://img.shields.io/github/stars/y-ren16/TiCodec.svg?style=social&label=Star)
- [**funcodec**](https://github.com/alibaba-damo-academy/funcodec) - alibaba-damo-academy ![Star](https://img.shields.io/github/stars/alibaba-damo-academy/funcodec.svg?style=social&label=Star)
- [**sonar**](https://github.com/facebookresearch/sonar) - facebookresearch ![Star](https://img.shields.io/github/stars/facebookresearch/sonar.svg?style=social&label=Star)

	 *SONAR, a new multilingual and multimodal fixed-size sentence embedding space, with a full suite of speech and text encoders and decoders.*
- **HiFi-Codec: Group-residual Vector quantization for High Fidelity Audio
  Codec**, `arXiv, 2305.02765`, [arxiv](http://arxiv.org/abs/2305.02765v2), [pdf](http://arxiv.org/pdf/2305.02765v2.pdf), cication: [**31**](https://scholar.google.com/scholar?cites=16848014406171770614&as_sdt=2005&sciodt=0,5&hl=en&oe=ASCII)

	 *Dongchao Yang, Songxiang Liu, Rongjie Huang, Jinchuan Tian, Chao Weng, Yuexian Zou*

	 · ([AcademiCodec](https://github.com/yangdongchao/AcademiCodec) - yangdongchao) ![Star](https://img.shields.io/github/stars/yangdongchao/AcademiCodec.svg?style=social&label=Star)
- **High-Fidelity Audio Compression with Improved RVQGAN**, `arXiv, 2306.06546`, [arxiv](http://arxiv.org/abs/2306.06546v2), [pdf](http://arxiv.org/pdf/2306.06546v2.pdf), cication: [**-1**](None)

	 *Rithesh Kumar, Prem Seetharaman, Alejandro Luebs, Ishaan Kumar, Kundan Kumar* · ([descript-audio-codec](https://github.com/descriptinc/descript-audio-codec) - descriptinc) ![Star](https://img.shields.io/github/stars/descriptinc/descript-audio-codec.svg?style=social&label=Star)
- **SpeechTokenizer: Unified Speech Tokenizer for Speech Large Language
  Models**, `arXiv, 2308.16692`, [arxiv](http://arxiv.org/abs/2308.16692v2), [pdf](http://arxiv.org/pdf/2308.16692v2.pdf), cication: [**-1**](None)

	 *Xin Zhang, Dong Zhang, Shimin Li, Yaqian Zhou, Xipeng Qiu* · ([speechtokenizer](https://github.com/zhangxinfd/speechtokenizer) - zhangxinfd) ![Star](https://img.shields.io/github/stars/zhangxinfd/speechtokenizer.svg?style=social&label=Star)
- **SoundStorm: Efficient Parallel Audio Generation**, `arXiv, 2305.09636`, [arxiv](http://arxiv.org/abs/2305.09636v1), [pdf](http://arxiv.org/pdf/2305.09636v1.pdf), cication: [**-1**](None)

	 *Zalán Borsos, Matt Sharifi, Damien Vincent, Eugene Kharitonov, Neil Zeghidour, Marco Tagliasacchi*
- **DinoSR: Self-Distillation and Online Clustering for Self-supervised
  Speech Representation Learning**, `arXiv, 2305.10005`, [arxiv](http://arxiv.org/abs/2305.10005v2), [pdf](http://arxiv.org/pdf/2305.10005v2.pdf), cication: [**-1**](None)

	 *Alexander H. Liu, Heng-Jui Chang, Michael Auli, Wei-Ning Hsu, James R. Glass*
- **High Fidelity Neural Audio Compression**, `arXiv, 2210.13438`, [arxiv](http://arxiv.org/abs/2210.13438v1), [pdf](http://arxiv.org/pdf/2210.13438v1.pdf), cication: [**-1**](None)

	 *Alexandre Défossez, Jade Copet, Gabriel Synnaeve, Yossi Adi*
- [EnCodec](https://huggingface.co/docs/transformers/main/en/model_doc/encodec#overview)
    - [notebooks/use\_encodec\_w\_transformers.ipynb at main · Vaibhavs10/notebooks · GitHub](https://github.com/Vaibhavs10/notebooks/blob/main/use_encodec_w_transformers.ipynb)
    - code: [GitHub - facebookresearch/encodec: State-of-the-art deep learning based audio codec supporting both mono 24 kHz audio and stereo 48 kHz audio.](http://github.com/facebookresearch/encodec)

- **SoundStream: An End-to-End Neural Audio Codec**, `arXiv, 2107.03312`, [arxiv](http://arxiv.org/abs/2107.03312v1), [pdf](http://arxiv.org/pdf/2107.03312v1.pdf), cication: [**-1**](None)

	 *Neil Zeghidour, Alejandro Luebs, Ahmed Omran, Jan Skoglund, Marco Tagliasacchi*

    - [GitHub - lucidrains/vector-quantize-pytorch: Vector Quantization, in Pytorch](https://github.com/lucidrains/vector-quantize-pytorch)

- **HuBERT: Self-Supervised Speech Representation Learning by Masked
  Prediction of Hidden Units**, `arXiv, 2106.07447`, [arxiv](http://arxiv.org/abs/2106.07447v1), [pdf](http://arxiv.org/pdf/2106.07447v1.pdf), cication: [**-1**](None)

	 *Wei-Ning Hsu, Benjamin Bolte, Yao-Hung Hubert Tsai, Kushal Lakhotia, Ruslan Salakhutdinov, Abdelrahman Mohamed*

- **wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
  Representations**, `arXiv, 2006.11477`, [arxiv](http://arxiv.org/abs/2006.11477v3), [pdf](http://arxiv.org/pdf/2006.11477v3.pdf), cication: [**-1**](None)

	 *Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael Auli*


## References
- [【機器學習2023】語音基石模型 (助教張凱為講授) (1/2) - YouTube](https://www.youtube.com/watch?v=m7Be7ppR6q0&ab_channel=Hung-yiLee)
- [【機器學習2023】語音基石模型 (助教張凱為講授) (2/2) - YouTube](https://www.youtube.com/watch?v=HTAq-CPrU5s&ab_channel=Hung-yiLee)
- [https://speech.ee.ntu.edu.tw/\~hylee/ml/ml2023-course-data/張凱爲-x-機器學習-x-語音基石模型.pdf](https://speech.ee.ntu.edu.tw/~hylee/ml/ml2023-course-data/%E5%BC%B5%E5%87%B1%E7%88%B2-x-%E6%A9%9F%E5%99%A8%E5%AD%B8%E7%BF%92-x-%E8%AA%9E%E9%9F%B3%E5%9F%BA%E7%9F%B3%E6%A8%A1%E5%9E%8B.pdf)