# Awesome ASR

- [Awesome ASR](#awesome-asr)
  - [Papers](#papers)
  - [Models](#models)
  - [Whisper](#whisper)
  - [Toolkits](#toolkits)

## Papers
- [Reverb Open-Source ASR and Diarization Models | Rev](https://www.rev.com/blog/speech-to-text-technology/introducing-reverb-open-source-asr-diarization)

	 · ([reverb](https://github.com/revdotcom/reverb?tab=readme-ov-file) - revdotcom) ![Star](https://img.shields.io/github/stars/revdotcom/reverb.svg?style=social&label=Star)
- **LA-RAG:Enhancing LLM-based ASR Accuracy with Retrieval-Augmented
  Generation**, `arXiv, 2409.08597`, [arxiv](http://arxiv.org/abs/2409.08597v1), [pdf](http://arxiv.org/pdf/2409.08597v1.pdf), cication: [**-1**](None)

	 *Shaojun Li, Hengchao Shang, Daimeng Wei, Jiaxin Guo, Zongyao Li, Xianghui He, Min Zhang, Hao Yang*
- [Seed-ASR: Understanding Diverse Speech and Contexts with LLM-based Speech Recognition](https://team.doubao.com/zh/publication/seed-asr-understanding-diverse-speech-and-contexts-with-llm-based-speech-recognition?view_from=research)

	 · ([jiqizhixin](https://www.jiqizhixin.com/articles/2024-08-22-8))
- **Scaling A Simple Approach to Zero-Shot Speech Recognition**, `arXiv, 2407.17852`, [arxiv](http://arxiv.org/abs/2407.17852v1), [pdf](http://arxiv.org/pdf/2407.17852v1.pdf), cication: [**-1**](None)

	 *Jinming Zhao, Vineel Pratap, Michael Auli* · ([fairseq](https://github.com/facebookresearch/fairseq/tree/main/examples/mms/zero_shot) - facebookresearch) ![Star](https://img.shields.io/github/stars/facebookresearch/fairseq.svg?style=social&label=Star)
- **Speech Slytherin: Examining the Performance and Efficiency of Mamba for
  Speech Separation, Recognition, and Synthesis**, `arXiv, 2407.09732`, [arxiv](http://arxiv.org/abs/2407.09732v1), [pdf](http://arxiv.org/pdf/2407.09732v1.pdf), cication: [**-1**](None)

	 *Xilin Jiang, Yinghao Aaron Li, Adrian Nicolas Florea, Cong Han, Nima Mesgarani* · ([Mamba-ASR](https://github.com/xi-j/Mamba-ASR) - xi-j) ![Star](https://img.shields.io/github/stars/xi-j/Mamba-ASR.svg?style=social&label=Star)
- **Investigating Decoder-only Large Language Models for Speech-to-text
  Translation**, `arXiv, 2407.03169`, [arxiv](http://arxiv.org/abs/2407.03169v1), [pdf](http://arxiv.org/pdf/2407.03169v1.pdf), cication: [**-1**](None)

	 *Chao-Wei Huang, Hui Lu, Hongyu Gong, Hirofumi Inaguma, Ilia Kulikov, Ruslan Mavlyutov, Sravya Popuri*
- **FunAudioLLM: Voice Understanding and Generation Foundation Models for
  Natural Interaction Between Humans and LLMs**, `arXiv, 2407.04051`, [arxiv](http://arxiv.org/abs/2407.04051v2), [pdf](http://arxiv.org/pdf/2407.04051v2.pdf), cication: [**-1**](None)

	 *Keyu An, Qian Chen, Chong Deng, Zhihao Du, Changfeng Gao, Zhifu Gao, Yue Gu, Ting He, Hangrui Hu, Kai Hu*

	 · ([fun-audio-llm.github](https://fun-audio-llm.github.io/))
	 · ([fun-audio-llm.github](https://fun-audio-llm.github.io/pdf/FunAudioLLM.pdf))

	 · ([SenseVoice](https://github.com/FunAudioLLM/SenseVoice) - FunAudioLLM) ![Star](https://img.shields.io/github/stars/FunAudioLLM/SenseVoice.svg?style=social&label=Star)
- [FunAudioLLM · GitHub](https://github.com/FunAudioLLM)

	 · ([fun-audio-llm.github](https://fun-audio-llm.github.io/pdf/FunAudioLLM.pdf))
- **Denoising LM: Pushing the Limits of Error Correction Models for Speech
  Recognition**, `arXiv, 2405.15216`, [arxiv](http://arxiv.org/abs/2405.15216v1), [pdf](http://arxiv.org/pdf/2405.15216v1.pdf), cication: [**-1**](None)

	 *Zijin Gu, Tatiana Likhomanenko, He Bai, Erik McDermott, Ronan Collobert, Navdeep Jaitly*
- **Conformer-1: Robust ASR via Large-Scale Semisupervised Bootstrapping**, `arXiv, 2404.07341`, [arxiv](http://arxiv.org/abs/2404.07341v1), [pdf](http://arxiv.org/pdf/2404.07341v1.pdf), cication: [**-1**](None)

	 *Kevin Zhang, Luka Chkhetiani, Francis McCann Ramirez, Yash Khare, Andrea Vanzo, Michael Liang, Sergio Ramirez Martin, Gabriel Oexle, Ruben Bousbib, Taufiquzzaman Peyash*
- **Towards a World-English Language Model for On-Device Virtual Assistants**, `arXiv, 2403.18783`, [arxiv](http://arxiv.org/abs/2403.18783v1), [pdf](http://arxiv.org/pdf/2403.18783v1.pdf), cication: [**-1**](None)

	 *Rricha Jalota, Lyan Verwimp, Markus Nussbaum-Thom, Amr Mousa, Arturo Argueta, Youssef Oualil*
- **Multilingual and Fully Non-Autoregressive ASR with Large Language Model
  Fusion: A Comprehensive Study**, `arXiv, 2401.12789`, [arxiv](http://arxiv.org/abs/2401.12789v1), [pdf](http://arxiv.org/pdf/2401.12789v1.pdf), cication: [**-1**](None)

	 *W. Ronny Huang, Cyril Allauzen, Tongzhou Chen, Kilol Gupta, Ke Hu, James Qin, Yu Zhang, Yongqiang Wang, Shuo-Yiin Chang, Tara N. Sainath*
- **Zipformer: A faster and better encoder for automatic speech recognition**, `arXiv, 2310.11230`, [arxiv](http://arxiv.org/abs/2310.11230v2), [pdf](http://arxiv.org/pdf/2310.11230v2.pdf), cication: [**-1**](None)

	 *Zengwei Yao, Liyong Guo, Xiaoyu Yang, Wei Kang, Fangjun Kuang, Yifan Yang, Zengrui Jin, Long Lin, Daniel Povey* · ([jiqizhixin](https://www.jiqizhixin.com/articles/2024-01-25-11))

## Models
- [**canary-1b**](https://huggingface.co/nvidia/canary-1b) - nvidia 🤗
- [**parakeet-tdt-1.1b**](https://huggingface.co/nvidia/parakeet-tdt-1.1b) - nvidia 🤗
- [**open_asr_leaderboard**](https://huggingface.co/spaces/hf-audio/open_asr_leaderboard) - hf-audio 🤗
- [**parakeet-ctc-0.6b**](https://huggingface.co/nvidia/parakeet-ctc-0.6b) - nvidia 🤗

## Whisper
- [**WhisperKit**](https://github.com/argmaxinc/WhisperKit) - argmaxinc ![Star](https://img.shields.io/github/stars/argmaxinc/WhisperKit.svg?style=social&label=Star)

	 *On-device Speech Recognition for Apple Silicon* · ([huggingface](https://huggingface.co/argmaxinc/whisperkit-coreml))
- [**Youtube-Whisper**](https://github.com/danilotpnta/Youtube-Whisper) - danilotpnta ![Star](https://img.shields.io/github/stars/danilotpnta/Youtube-Whisper.svg?style=social&label=Star)

	 *A Gradio app that transcribes YouTube videos using audio extraction and OpenAI’s Whisper model.*
- [**whisper-large-v3-turbo**](https://huggingface.co/openai/whisper-large-v3-turbo) - openai 🤗
- [Fine-Tune Whisper For Multilingual ASR with 🤗 Transformers](https://huggingface.co/blog/fine-tune-whisper)
- [**whisper-medusa**](https://github.com/aiola-lab/whisper-medusa) - aiola-lab ![Star](https://img.shields.io/github/stars/aiola-lab/whisper-medusa.svg?style=social&label=Star)

	 *Whisper with Medusa heads* · ([huggingface](https://huggingface.co/aiola/whisper-medusa-v1)) · ([medium](https://medium.com/@sgl.yael/whisper-medusa-using-multiple-decoding-heads-to-achieve-1-5x-speedup-7344348ef89b))
- [**whisper-web**](https://github.com/xenova/whisper-web/tree/experimental-webgpu) - xenova ![Star](https://img.shields.io/github/stars/xenova/whisper-web.svg?style=social&label=Star)
- [**WhisperLive**](https://github.com/collabora/WhisperLive) - collabora ![Star](https://img.shields.io/github/stars/collabora/WhisperLive.svg?style=social&label=Star)

	 *A nearly-live implementation of OpenAI's Whisper.*
- [Faster and Smaller Whisper: A Deep Dive into Quantization and Torch Compilation](https://mobiusml.github.io/whisper-static-cache-blog/)
- [**faster-whisper-server**](https://github.com/fedirz/faster-whisper-server) - fedirz ![Star](https://img.shields.io/github/stars/fedirz/faster-whisper-server.svg?style=social&label=Star)
- [**whisper-diarization**](https://github.com/MahmoudAshraf97/whisper-diarization) - MahmoudAshraf97 ![Star](https://img.shields.io/github/stars/MahmoudAshraf97/whisper-diarization.svg?style=social&label=Star)

	 *Automatic Speech Recognition with Speaker Diarization based on OpenAI Whisper*
- [**asr-diarization**](https://huggingface.co/blog/asr-diarization) -  🤗
- [**distil-large-v3**](https://huggingface.co/distil-whisper/distil-large-v3) - distil-whisper 🤗
- **OWSM v3.1: Better and Faster Open Whisper-Style Speech Models based on
  E-Branchformer**, `arXiv, 2401.16658`, [arxiv](http://arxiv.org/abs/2401.16658v1), [pdf](http://arxiv.org/pdf/2401.16658v1.pdf), cication: [**-1**](None)

	 *Yifan Peng, Jinchuan Tian, William Chen, Siddhant Arora, Brian Yan, Yui Sudo, Muhammad Shakeel, Kwanghee Choi, Jiatong Shi, Xuankai Chang*
- [**whisperkit-coreml**](https://huggingface.co/argmaxinc/whisperkit-coreml) - argmaxinc 🤗

	 · ([takeargmax](https://www.takeargmax.com/blog/whisperkit))
- **Reproducing Whisper-Style Training Using an Open-Source Toolkit and
  Publicly Available Data**, `arXiv, 2309.13876`, [arxiv](http://arxiv.org/abs/2309.13876v3), [pdf](http://arxiv.org/pdf/2309.13876v3.pdf), cication: [**-1**](None)

	 *Yifan Peng, Jinchuan Tian, Brian Yan, Dan Berrebbi, Xuankai Chang, Xinjian Li, Jiatong Shi, Siddhant Arora, William Chen, Roshan Sharma* · ([huggingface](https://huggingface.co/espnet/owsm_v3)) · ([huggingface](https://huggingface.co/spaces/pyf98/OWSM_v3_demo))
- **Distil-Whisper: Robust Knowledge Distillation via Large-Scale Pseudo
  Labelling**, `arXiv, 2311.00430`, [arxiv](http://arxiv.org/abs/2311.00430v1), [pdf](http://arxiv.org/pdf/2311.00430v1.pdf), cication: [**-1**](None)

	 *Sanchit Gandhi, Patrick von Platen, Alexander M. Rush* · ([distil-whisper](https://github.com/huggingface/distil-whisper) - huggingface) ![Star](https://img.shields.io/github/stars/huggingface/distil-whisper.svg?style=social&label=Star)
- [**whisperX**](https://github.com/m-bain/whisperX) - m-bain ![Star](https://img.shields.io/github/stars/m-bain/whisperX.svg?style=social&label=Star)

	 *WhisperX: Automatic Speech Recognition with Word-level Timestamps (& Diarization)*
- [**insanely-fast-whisper**](https://github.com/Vaibhavs10/insanely-fast-whisper/) - Vaibhavs10 ![Star](https://img.shields.io/github/stars/Vaibhavs10/insanely-fast-whisper.svg?style=social&label=Star)
- [**faster-whisper**](https://github.com/guillaumekln/faster-whisper) - guillaumekln ![Star](https://img.shields.io/github/stars/guillaumekln/faster-whisper.svg?style=social&label=Star)

	 *Faster Whisper transcription with CTranslate2*
- [**whisper_streaming**](https://github.com/ufal/whisper_streaming) - ufal ![Star](https://img.shields.io/github/stars/ufal/whisper_streaming.svg?style=social&label=Star)

	 *Whisper realtime streaming for long speech-to-text transcription and translation*
- [**Whisper-WebUI**](https://github.com/jhj0517/Whisper-WebUI) - jhj0517 ![Star](https://img.shields.io/github/stars/jhj0517/Whisper-WebUI.svg?style=social&label=Star)

	 *A Web UI for easy subtitle using whisper model.*
- [Speculative Decoding for 2x Faster Whisper Inference](https://huggingface.co/blog/whisper-speculative-decoding)

---
- [**ratchet-whisper**](https://huggingface.co/spaces/FL33TW00D-HF/ratchet-whisper) - FL33TW00D-HF 🤗

## Toolkits
- [Accelerating Leaderboard-Topping ASR Models 10x with NVIDIA NeMo | NVIDIA Technical Blog](https://developer.nvidia.com/blog/accelerating-leaderboard-topping-asr-models-10x-with-nvidia-nemo/)
- [**aTrain**](https://github.com/JuergenFleiss/aTrain) - JuergenFleiss ![Star](https://img.shields.io/github/stars/JuergenFleiss/aTrain.svg?style=social&label=Star)

	 *A GUI tool for offline transcription of speech recordings, including speaker diarization, utilizing state-of-the-art machine learning models.*
- [**NeMo**](https://github.com/NVIDIA/NeMo) - NVIDIA ![Star](https://img.shields.io/github/stars/NVIDIA/NeMo.svg?style=social&label=Star)

	 *NeMo: a toolkit for conversational AI*
- [**FunASR**](https://github.com/alibaba-damo-academy/FunASR) - alibaba-damo-academy ![Star](https://img.shields.io/github/stars/alibaba-damo-academy/FunASR.svg?style=social&label=Star)

	 *A Fundamental End-to-End Speech Recognition Toolkit and Open Source SOTA Pretrained Models.*
- [**automatic-speech-recognition**](https://huggingface.co/spaces/k2-fsa/automatic-speech-recognition) - k2-fsa 🤗

## Products
- [AssemblyAI Research | Building the world's leading Speech AI models](https://www.assemblyai.com/research/universal-1)