from brainzutils import cache
from brainzutils.musicbrainz_db import recording as db

from critiquebrainz.frontend.external.musicbrainz_db import DEFAULT_CACHE_EXPIRATION


def get_recording_by_mbid(mbid):
    """Get recording with MusicBrainz ID.

    Args:
        mbid (uuid): MBID(gid) of the recording.
    Returns:
        Dictionary containing the recording information
    """
    key = cache.gen_key('recording', mbid)
    recording = cache.get(key)
    if not recording:
        recording = db.get_recording_by_mbid(
            mbid,
            includes=['artists', 'work-rels', 'url-rels'],
        )
        if not recording:
            return None
        cache.set(key, recording, DEFAULT_CACHE_EXPIRATION)
    return recording
