<h1 align="center">
  <br>
  <a href="https://critiquebrainz.org"><img src="https://github.com/metabrainz/metabrainz-logos/blob/master/logos/CritiqueBrainz/SVG/CritiqueBrainz_logo.svg" alt="CritiqueBrainz"></a>
</h1>
<h4 align="center">Server for the CritiqueBrainz project</h4>
<p align="center">
    <a href="https://github.com/metabrainz/critiquebrainz/commits/master">
    <img src="https://img.shields.io/github/last-commit/metabrainz/critiquebrainz.svg?style=flat-square&logo=github&logoColor=white"
         alt="GitHub last commit"></a>
    <a href="https://github.com/metabrainz/critiquebrainz/pulls">
    <img src="https://img.shields.io/github/issues-pr-raw/metabrainz/critiquebrainz?style=flat-square&logo=github&logoColor=white"
         alt="GitHub pull requests"></a>
</p>
<p align="center">
  <a href="https://critiquebrainz.org">Website</a> •
  <a href="https://critiquebrainz.readthedocs.io">Documentation</a> •
  <a href="https://tickets.metabrainz.org/projects/CB/issues">Bug tracker</a>
</p>

---

## About

CritiqueBrainz is a repository for Creative Commons licensed music and book reviews. Here you can read what other people have written about an album or event and write your own review!

CritiqueBrainz is based on data from [MusicBrainz](https://musicbrainz.org) - open music encyclopedia and [BookBrainz](https://bookbrainz.org) - open book encyclopedia.
Everyone - including you - can participate and contribute.

CritiqueBrainz is operated by the [MetaBrainz Foundation](https://metabrainz.org)
which has a long-standing history of curating, protecting and making music and book data available to the
public.

For more information about this project, look at our
[website](https://critiquebrainz.org/).

Changes and other important announcements about the CritiqueBrainz services will be
announced on [our blog](https://blog.metabrainz.org/). If you start using our
services in any production system, we urge you to follow the blog!

## Commercial use

All of our data is available for commercial use. You can find out more about our
[commercial use support tiers](https://metabrainz.org/supporters/account-type) on 
the MetaBrainz site.

## Contributing

If you are interested in helping out, consider
[donating](https://metabrainz.org/donate) to the MetaBrainz Foundation.

If you are interested in contributing code or documentation,
please have a look at the [issue tracker](https://tickets.metabrainz.org/browse/CB)
or come visit us in the #metabrainz IRC channel on irc.libera.chat.

## Documentation

Documentation is available at https://critiquebrainz.readthedocs.io/.
 
### Building documentation

If you want to build documentation yourself, follow these steps using python 3

    $ cd ./docs
    $ pip3 install -r requirements.txt
    $ make html

After that open `./docs/_build/html/index.html` in your favourite browser.

## License Notice

```
Copyright (C) 2022 MetaBrainz Foundation Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
```
