# Tech Companies in Nepal

List of tech companies (or teams) that are based or working in Nepal. :nepal:

|                 |                 |                 |                 |                 |                 |                 |                 |                 |
| :-------------: | :-------------: | :-------------: | :-------------: | :-------------: | :-------------: | :-------------: | :-------------: | :-------------: |
| [A - C](#a---c) | [D - F](#d---f) | [G - I](#g---i) | [J - L](#j---l) | [M - O](#m---o) | [P - R](#p---r) | [S - U](#s---u) | [V - X](#v---x) | [Y - \#](#y---) |

**Website:** https://airtable.com/shrXv3YvlfxLnHJfr

## Add a new Company to the List

- [Fork](https://guides.github.com/activities/forking) the repository
- Add your company in alphabetical order using the mentioned format below
- Company description should be short and should not end with a period
- Here's a good [example](https://github.com/mesaugat/tech-companies-in-nepal/pull/7/files)

### Format

```
- [Company Name](https://my.company) | location, city | what does it do
```

### Duds

If you cannot provide a valid website for your company, your PR will not be accepted.

### Download

You can sort/filter/download the data from [Airtable](https://airtable.com/shrXv3YvlfxLnHJfr). Additions to this document are automatically pushed to Airtable using the API [here](https://github.com/mesaugat/tech-companies-in-nepal-api).

**Bonus:** Here's an [API](https://tech-companies-in-nepal.herokuapp.com/api/companies) to get all companies in JSON format.

---

## A - C

- [Aayulogic Pvt. Ltd.](https://aayulogic.com/) | Min Bhawan, Kathmandu | Software solutions including, but not limited to, web development, web desigining, web/domain hosting and CMS
- [Admana Technology Pvt. Ltd.](https://admana.net/) | Tripureshwor, Kathmandu | We are a Digital Ad Network Platform through which you can put your ads in 70+ websites of Nepal and pay according to your budget
- [Agile Solutions](https://agile.com.np) | Dhumbarahi, Kathmandu | We provide a full range of ERP, CRM, and BI services from implementation to support and development
- [AITC International Pvt. Ltd.](https://aitc.ai) | Radhe Radhe, Bhaktapur | IT solutions, Web designing, Software development, Digital marketing and App development
- [Allied Netlink Technology Pvt. Ltd.](https://ant.com.np/) | Putalisadak, Kathmandu | Internet Service Provider (ISP)
- [Ambarkaar Software Pvt. Ltd.](https://compliancequest.com/) | Bakhundol, Lalitpur | Ambarkaar is a subsidiary company of ComplianceQuest, we develop Enterprise Quality Management System in Salesforce
- [Amnil Technologies Pvt. Ltd.](https://amniltech.com/) | Manbhawan, Lalitpur | Sharepoint, Web Solutions, Web Development, Web Design, Software Development, Graphic Designs, Mobile Application
- [Amsoft Technologies](https://amsoft.com.np) | Gwarko, Lalitpur | An IT Consulting and Software Company serving in IT related areas since its incorporation
- [Anubhabi Technologies Pvt. Ltd.](https://www.anubhabi.com/) | Koteshwor, Kathmandu | At Anubhabi we provide high-end online web and software development solutions to start-ups and medium to large scale companies
- [Aspark Systems](https://asparksys.com/) | Basuki Marg, Kathmandu | We develop real world projects at such efficiency rate that no other development company can offer
- [Asterdio Inc.](https://asterdio.com/) | Sankhamul, Kathmandu | Web Design/Development, Multimedia Development, Social Media Management and Hosting Solutions
- [Astranix Technologies Pvt. Ltd.](https://astranix.com) | Bharatpur, Chitwan | Domain Registration, Hosting Solutions, Web Design/Development, Software Development
- [Atlas Tek Pvt. Ltd.](https://atlastek.com.np) | Gyaneshwor, Kathmandu | An IT company with a specialization in creating new and innovative tools to cater to the need of modern days IT organizations as well as providing enterprise application development
- [Avoloft Technologies](https://avoloft.com/) | Tinkune, Kathmandu | Delivers cutting-edge SaaS-based LMS and innovative web and mobile app development solutions
- [Awecode](https://awecode.com/) | Buddhanagar, Kathmandu | We build awesome applications
- [Ayat Digital Pvt. Ltd.](https://www.ayatdigital.com/) | Balkhu, Kathmandu | We innovate, discover, invent and integrate technology to simplify and ease lives
- [Axios Softwork](https://axiossoftworks.com/) | Banepa, Kavrepalanchowk | Offer commercial organizations cutting-edge intelligent technical solutions and services on web development and mobile app development
- [Bajra Technologies](https://bajratechnologies.com/) | Tinkune, Kathmandu | We are a technology company that primarily focuses and excels in building software which bring our customer's ideas to life
- [BatchNepal Consultancy](https://batchnepal.com/) | Bishalnagar, Dhangadhi | Leader in IT services, consulting, outsourcing, and business solutions, leverages technology for business transformation and success
- [Bhoos Games](https://www.bhoos.com/) | Jwagal, Lalitpur | Recreate conversations, laughter with card games on mobile
- [Bidhee Pvt. Ltd.](https://www.bidhee.com/) | New Baneshwor, Kathmandu | A company solely established for development and deployment of products with Specialization in development of Mobile/Web applications and Custom Software
- [Bits Innovation](https://bitsinnovation.com/) | New Baneshwor, Kathmandu | Provides services like Website Design & Development, Search Engine Optimization, Mobile Apps Development and Web Hosting
- [Black Tech](https://www.blacktech.com.np/) | Zero Kilometer, Pokhara | App Development, Web Development, Branding/Designing, Digital Marketing
- [BlackBox Technologies Pvt. Ltd.](https://www.bboxtech.com/) | Patan, Lalitpur | Market leader in email marketing, offering web-based email marketing solutions and services for organizations who want to maintain an active relationship with their customers
- [Blanxer Technologies Pvt. Ltd.](https://www.blanxer.com/) | Madhyapur Thimi, Bhaktapur | All-in-one e-commerce platform for creating websites, managing orders, and streamlining social media DM orders
- [Braindigit](https://www.braindigit.com/) | Gyaneshwor, Kathmandu | Building applications for businesses and mobile on a native platform, with driven project teams you can call yours
- [BroadLink Network and Communication Pvt. Ltd.](https://broadlink.com.np/) | Sanepa, Lalitpur | Internet Service Provider
- [Cedar Gate Technologies](https://www.cedargate.com/) | Sanepa, Lalitpur | Provide platform for proactive healthcare and benefits management
- [CellApp Innovations](https://cellapp.co/) | Lainchaur, Kathmandu | We develop and deliver Accelerating Technology to Organizations and Businesses
- [Centerpoint Networks Pvt. Ltd.](https://centerpoint-networks.com/) | Golfutar, Kathmandu | Software Solutions, Web Application Development, ERP, CRM
- [Channakya Software Pvt. Ltd.](https://www.channakyasoft.com/) | Sinamangal, Kathmandu | We build banking software, assets management software, attendance management software, payroll management software, human resource management and cheque management software
- [Chhito Connect Pvt. Ltd.](https://www.chhitoconnect.com/) | Anamnagar, Kathmandu | Digital Banking Products
- [Chulo Solutions Pvt. Ltd.](https://chulo-solutions.com) | Kumaripati, Lalitpur | Software development company
- [Cixware Pvt. Ltd.](https://cixware.io) | New Baneshwor, Kathmandu | Web and Mobile apps development, DevOps, Cloud services integration and automation
- [Classic Tech Pvt. Ltd.](https://www.classic.com.np/) | New Baneshwor, Kathmandu | Internet Service Provider (ISP) and Network Service Provider (NSP)
- [Cloco Nepal Inc. Pvt. Ltd.](https://cloco.com.np/) | Chakupat, Lalitpur | We provide cutting-edge solutions that encompass web design & development, digital marketing, graphic design, IT consulting & support, and mobile app development
- [CloudFactory Nepal](https://www.cloudfactory.com.np/) | Jhamsikhel, Lalitpur | On-Demand Workforce for Data Work
- [Cloudy Fox Technology Pvt. Ltd.](https://www.cloudyfox.io) | Anamnagar, Kathmandu | Software Development, Support, Maintenance & Security
- [Clusus Information Solutions Pvt. Ltd.](https://www.clusus.com) | Jhamsikhel, Lalitpur | Leading provider of banking and payment solutions focused bestowing excellence and distinction to the Banking and Financial industry
- [Code Kavya](https://codekavya.com/) | Nadipur, Pokhara | Codekavya is a design and development company specialized in creating beautiful and scalable full-stack web and mobile applications
- [Code Pixelz Media Pvt. Ltd.](https://codepixelzmedia.com/) | Ekantakuna, Lalitpur | WordPress theme and plugin development agency
- [Codewing Solutions](https://codewing.co/) | Bishalnagar, Kathmandu | Codewing Solutions is a creative digital agency specialized in providing quality website design and development, search engine optimisation (SEO) and mobile apps development
- [Codniv Innovations Pvt. Ltd.](https://codniv.com) | Basundhara, Kathmandu | Codniv is a one-stop-shop for software development where we provide custom software development solutions across all industries that will help you ease in your work and reach thousands of customers
- [Comptech International](https://comptech.com.np) | Banasthali, Kathmandu | Accounting softwares and automation solutions
- [Convergetree Technologies Pvt. Ltd.](https://www.convergetree.com/) | Kupondole, Lalitpur | Full-stack software development company specializing in Web and Mobile applications including high-load enterprise solutions, Big Data, and parallel data processing
- [Cotiviti Nepal Pvt. Ltd.](https://cotiviti.com.np) | Hattisar, Kathmandu | Software research and development center
- [Crimson Tech](https://crimsontech.io/) | Balkumari, Lalitpur | Engineering solution specialization on Computer Vison, AI/ML, IOT, Software Development, Industrial Automation
- [Crumet Tech](https://crumet.com/) | Lakeside, Pokhara | Crumet empowers startups with tailored app development, system modernization, software integration, cloud services, digital marketing, and strategic consulting
- [Crystal Infosys](https://crystalinfosys.com/) | Jadibuti, Kathmandu | Web Development, Internet Marketing SEO
- [Curves n' Colors](https://curvesncolors.com/) | Kamaladi, Kathmandu | Design, Copywriting, Branding
- [Cyclone Nepal Infotech Pvt. Ltd.](https://cninfotech.com/) | Shankhamul, Kathmandu | Transform Your Business Into Digital Platform

## D - F

- [Daanfe Inc Pvt. Ltd.](https://www.daanfe.com/) | Sankhamul, Kathmandu | Wings For Ideas
- [Dallo Tech](https://dallotech.com/) | Khumaltar, Lalitpur | We build software solutions tailored for your problems
- [Danfe Solution Pvt. Ltd.](https://danfesolution.com/) | Gyaneshwor, Kathmandu | IT Company focusing on Web Development, Mobile Application and Desktop Application
- [Danphe Software Labs Pvt. Ltd.](https://www.danpheit.com/) | Anamnagar, Kathmandu | We specialize in Software and Web Development
- [Dasmalab](https://dasmalab.com/) | Sanepa, Lalitpur | Software, websites and apps development along with data computing and visualization service
- [Deerwalk](https://www.deerwalk.com/) | Sifal, Kathmandu | Bringing you software solutions for POPULATION HEALTH MANAGEMENT
- [Deerhold](https://www.deerhold.org/) | Sifal, Kathmandu | Provides software development and IT services to clients around the globe
- [Devfinity](https://devfinity.io) | New Baneshwor, Kathmandu | A digital revolution company to solve your technology needs
- [Digital Age Nepal](https://digitalagenepal.com/) | Tahachal, Kathmandu | Develop promising software that include KYC Management, Screening, CPFDS AML Solutions, Data Validation and Online Accounting Solutions
- [Docsumo](https://www.docsumo.com/) | Mitrapark, Kathmandu | Intelligent Data Capture and Extraction with OCR and AI
- [Dolphin Dive Technology Pvt. Ltd.](https://dolphindivetech.com/) | Jhamsikhel, Lalitpur | CRM, Mobile Based Applications, Enterprise Solutions and Big Data Analysis
- [D-Tech Office System Pvt. Ltd.](https://d-tech.com.np/) | New Baneshwor, Kathmandu | Software, Web and Corporate Solutions Provider
- [EagleVision IT](https://eaglevisionit.com) | Manbhawan, Lalitpur | Development agency that operates on WordPress based designs, offering high-end solutions for web and mobile market
- [EB Pearls](https://www.ebpearls.com.au/) | Kupondole, Lalitpur | Digital agency for web design, ecommerce and mobile app development
- [E-Digital Nepal Pvt. Ltd.](https://edigitalnepal.com) | Tinkune, Kathmandu | We work in transforming the education sector of Nepal with the use of information and communication technology
- [Eepos IT Services](https://www.eeposit.com/) | Old Baneshwor, Kathmandu | We are a full service mobile application, web, and custom software development company
- [E.K. Solutions Pvt. Ltd.](https://ekbana.com/) | Kupondole, Lalitpur | Web Application Development, Mobile Application Development, Android & iOS Application Development
- [Elytra Solutions Pvt. Ltd.](https://elytrasolutions.com/) | Tokha, Kathmandu | Web Development, Mobile Application Development, Software Development, Blockchain Development, Data Analysis, Digital Marketing
- [Eminence Ways Pvt. Ltd.](https://eminenceways.com/) | Maitidevi, Kathmandu | Vulnerability Assessment and Penetration Testing, Information Systems Audit, Dedicated Cyber Security Company
- [E-Multitech Solution Pvt. Ltd.](https://www.emultitechsolution.com) | Kupondol, Lalitpur | We are a company specialising in auction software, web design, web development, mobile apps, e-commerce, and other services
- [E-Prabidhi Pvt. Ltd.](https://www.eprabidhi.com/) | Putalisadak, Kathmandu | Web Developement, Domain Hosting, Software Development and Graphics Designing
- [ESignature Pvt. Ltd.](https://esignature.com.np/) | Gyaneshwor, Kathmandu | Web-based solutions, web development, software solutions and IT service provider
- [Exotrac](https://exotrac.com/) | Old Baneshwor, Kathmandu | Leading provider of real time logistics management software for automotive, manufacturing, retail, and supply chain logistics industries
- [Expresiv Studios](https://expresivstudios.com/) | Dillibazar, Kathmandu | UI/UX Design for Mobile, Web & Beyond
- [Fatdog Labs](https://fatdoglabs.com/) | Baneshwor, Kathmandu | Web Application Development, Mobile Application Development, Android & iOS Application Development
- [Fawesome Apps](https://fawesomeapps.com/) | Putalisadak, Kathmandu | We make friggin’ awesome apps
- [FleetPanda](https://www.fleetpanda.com/) | Milan Chowk Marga, Kathmandu | Delivery management platform, offering route optimization, real-time tracking, and driver management for businesses with vehicle fleets
- [Fusemachines Nepal Pvt. Ltd.](https://fusemachines.com.np/) | Hattisar, Kathmandu | We create intelligent software solutions that transform brands, grow businesses and make people's lives easier
- [F1Soft International](https://f1soft.com/) | Pulchowk, Lalitpur | FinTech company providing services to more than 90% of the banks and financial institutions in the country

## G - I

- [Grepsr](https://www.grepsr.com/) | Naxal, Kathmandu | The simplest web scraping platform
- [GrowByData](https://growbydata.com/) | Kupondole, Lalitpur | Ecommerce data services for online retailers
- [Growcept](https://growcept.com/) | Pulchowk, Lalitpur | Growcept is a tech products platform
- [Gurkhatech](https://gurkhatech.com/) | New Baneshwor, Kathmandu | App & Web Development, Facebook Marketing Nepal
- [Gurzu](https://gurzu.com/) | Balkumari, Lalitpur | Gurzu helps world-class customers get to their markets quickly with very high quality products built with modern software technologies
- [Hamro Patro](https://hamropatro.com) | Sifal, Kathmandu | Hamro Patro is one of the first Nepali app to include Nepali Patro
- [Heartsun Technology](https://heartsunntsoft.com/) | Bharatpur, Chitwan | Software Company with .NET platform
- [HelloWorldCorp](https://helloworldcorp.biz/) | Gairidhara, Kathmandu | Web Development Company
- [HiTech Solutions & Services Pvt. Ltd.](https://hitechnepal.com.np/) | Kalimati, Kathmandu | Provides service on Application Software, Customized Software Development, Web Site Design and Development, Web & Mobile Application development and Hardware Sales & Networking Solutions
- [HiUp Solutions Pvt. Ltd.](https://hiupapp.com/) | Chabahil, Kathmandu | HiUp app enables you to get the best jobs in the construction, retail and hospitality
- [Hoostly](https://hoostly.com/) | Gwarko, Kathmandu | Affordable domains & shared hosting
- [I3 Web Solution](https://www.i3websolution.com/) | Banasthali, Kathmandu | We provide the best long-term web solutions, and build the best website that suites your business needs
- [Iceberg Technology Pvt. Ltd.](https://icebergtechnepal.com/) | Chandol, Kathmandu | An IT service company providing full and fractional IT services to small and mid-sized businesses
- [Imagio Creations Pvt. Ltd.](https://imagiocreations.com/) | Jhamsikhel, Lalitpur | Software Development, Website Design & Development, Mobile App Development, Branding, Marketing, Staff Augmentation
- [Impetus Incorporation Pvt. Ltd.](https://impetus.com.np/) | Pulchowk, Lalitpur | IT Offshore Service Provider
- [Incessant Rain Animation Studios](https://www.incessantrain.com/) | Chhauni, Kathmandu | We specialize in 3D character animation, visual effects for feature films, game cinematics, commercials and integrated media
- [Incwell Venture](https://incwellventure.com/) | Jhamsikhel, Kathmandu | Software Development, Marketing, Events, Creative Content Creation
- [Inficare](https://www.inficare.com.my/) | Gairidhara, Kathmandu | Provides completely tailored software development & consultancy services for financial institutions
- [Infinia Hub Pvt. Ltd.](https://infiniahub.com/) | Tinkune, Kathmandu | Software Development Company
- [Infinite IT Solutions Nepal](https://infiniteitsolutionsnepal.com/) | Oil Nigam Kharji, Biratnagar | Provide end-to-end software and mobile application development services
- [Infinity Digital Agency](https://infinitydigitalagency.com.np/) | Maitidevi, Kathmandu | Social Media Management, Software & App Solutions, Graphics Design & Visual Arts, Web Development & Management, Photography & Videography, Digital Branding & Marketing
- [Inflancer Technology](https://inflancer.net/) | Gwarko, Lalitpur | Excels in MERN Stack, React Native, Flutter, React, Laravel, Digital Marketing, and SEO, delivering innovative, top-quality software solutions through a dedicated and skilled team
- [InfoDevelopers](https://www.infodev.com.np) | Sanepa, Lalitpur | Providing innovative, quality, cost effective IT Services and Software solutions for business process automation and re-engineering
- [Innovate Tech](https://innovatetech.io/) | Baluwatar, Kathmandu | We work to deliver cutting edge, scalable, secure and easy to use products
- [Inquiry Nepal](https://www.inquirynepal.com) | New Baneshwor, Kathmandu | Nepal's Premier Business Directory which aims to Connect Nepali Businesses to it's customers
- [Insight Workshop](https://insightworkshop.io/) | Kamalpokhari, Kathmandu | Software Development Company
- [InternSathi](https://internsathi.com/) | Sankhamul, Kathmandu | InternSathi is an internship-focused platform started with the main focus of helping students get quality internships and help them excel at it
- [IntroCept Nepal](https://nepal.introcept.co/) | Dhobighat, Lalitpur | A concept development company with skills and expertise to facilitate complex business solutions
- [Ishani Technology Pvt. Ltd.](https://ishanitech.com/) | Hattiban, Lalitpur | Mobile and Web Development
- [IT Advisors Nepal](https://www.itadvisorsnepal.com/) | Dhumbarahi, Kathmandu | IT Consulting, Application Architecture and Digital Solutions
- [Itonics](https://www.itonics.de/) | Anamnagar, Kathmandu | Big Data analytics, trend and technology scouting, monitoring and management

## J - L

- [Janaki Tech](https://janakitech.com/) | Harihar Bhawan, Lalitpur | We strive to build better software useful for everyone
- [JankariTech](https://www.jankaritech.com/) | Nayagaun, Pokhara | We specialize in helping customers set up test automation
- [Javra](https://javra.com/) | Kumaripati, Lalitpur | IT solutions that boost productivity in business
- [JyabaTech](https://jyaba.tech/) | Shanti Marg, Pokhara | Data Scraping (acquisition) at scale & Data Engineering
- [Karkhana](https://www.karkhana.asia/) | Pashupati Rd, Kathmandu | An education company and makerspace with a unique approach to learning
- [Kathmandu Living Labs](https://www.kathmandulivinglabs.org/) | Maharajgunj, Kathmandu | Non Profit civic tech company
- [Kazi Studios](https://www.kazistudios.com/) | Ekantakuna, Kathmandu | Solving complex problems through design and technology
- [Lanceme Up](https://lancemeup.com/) | Dhobighat, Lalitpur | Your all-in-one virtual workspace for managing clients and teams
- [Laser InfoTech Pvt. Ltd.](https://www.laser-infotech.com/) | Bhaisepati, Lalitpur | Your trusted partner for Web Design & Development, Mobile App Development and Viral Marketing
- [Leapfrog Technology](https://lftechnology.com/) | Dillibazar, Kathmandu | We build world-class software for you
- [Libresoft IT Solutions](https://libresoft.com.np/) | Dillibazar, Kathmandu | We provide Enterprise level Open Source Solutions, Trainings & Consultation in Linux System Administration & Networkings
- [LinkBinary](https://www.linkbinary.com/) | Birtamode, Jhapa | Provides digital services in simple yet secured, integrated and most comprehensive way while taking care of fairly adrifted digital quality
- [LIS Nepal](https://www.lisnepal.com.np/) | Manbhawan, Lalitpur | Service centric Information Technology firm with special focus on retail industry. Our expertise lies in Business Intelligence (BI), Data Warehousing, and Data Analytics
- [LogPoint](https://www.logpoint.com/) | Jawalakhel, Lalitpur | Provides full enterprise SIEM solution
- [Ltech Services Inc.](https://www.useltech.com/) | Thapagaun, Kathmandu | Web development, App development, Outsourcing, DevOps, QA, Digital marketing and SEO
- [Lunover Digital](https://www.lunover.com/) | Naya Bazar, Kathmandu | Information Technology and Services

## M - O

- [Mahuri Ventures](https://mahuriventures.com) | Bharatpur, Chitwan | Smart Solution for Smart Business
- [Makura Creations](https://makuracreations.com) | Pulchowk Rd, Patan | Web design/development, Software development, Mobile app development, Social media marketing and SEO
- [Manaram Technology](https://www.manaram.technology/) | Baluwatar, Kathmandu | We are Digital Innovators who love turning visions into reality
- [Mandala System Pvt. Ltd.](https://mandalasystem.com.np/) | New Baneshwor, Kathmandu | Web design/development, Desktop Application development
- [Mantra Ideas Pvt. Ltd.](https://mantraideas.com/) | Manbhawan, Lalitpur | IT Company providing services related to web and mobile app development
- [Mantra IT](https://mantrait.com.np/) | Banglamukhi, Lalitpur | Striving to provide professional IT services to companies seeking prosperity and growth in all of their IT aspects, ranging from developing an excellent website to enhancing their overall digital market achievement
- [Mercantile Communications Pvt. Ltd.](https://www.mos.com.np/) | Durbar Marg, Kathmandu | Provides comprehensive range of excellent value added services for Internet, content designing, development and hosting
- [Mhuchya Technology](https://mhuchya.com.np/) | Sankhamul, Kathmandu | United for the development of Technology in Nepal, globally
- [Microsoft Innovation Center Nepal](https://micnepal.org) | Khichapokhari, Kathmandu | Provides access to world-class resources for students, software developers, IT professionals & entrepreneurs
- [MPercept Technology](https://mpercept.com/) | Kupondole, Kathmandu | Building Fully Autonomous AI Technology to make things easier
- [Nagarjun Software Technosys Pvt. Ltd.](https://nagarjunsofttech.com/) | Nagarjun, Kathmandu | Online Marketing and Mobile Apps Software Development
- [Naxa Pvt. Ltd.](https://naxa.com.np/) | Maharajgunj, Kathmandu | Address contemporary problems in developing countries through technological innovations, particularly in digital and spatial technology
- [NebulaLeap Technology Pvt. Ltd.](https://nebulaleap.com) | Chakupat, Lalitpur | We are top 1% software engineers, pioneer in developing MVP for startups and also work on E-commerce development
- [Neem Infosys](https://neeminfosys.com/) | Mahendranagar, Kanchanpur | We develop user-centric website, mobile apps and digital marketing that grows startup and existing businesses in the sales and service industries
- [Nepal Digital Systems Pvt. Ltd.](https://nepaldigisys.com/) | Dhobighat, Lalitpur | A consulting company specialized in hardware design, embedded software (firmware) engineering, and Internet of Things (IoT) solutions
- [Nepasoft Solutions LLC](https://nepasoft.com/) | Gairidhara, Kathmandu | Team of experienced professionals with passion for delivering high quality software solutions, products and services
- [Nepbix Technology Pvt. Ltd.](https://www.nepbix.com/) | Tinkune, Kathmandu | NepBix Technology is a renowned mobile and web app development company & IT Software Solutions provider based in Australia & Nepal
- [NepXpress Cargo & Courier](https://www.nepxpress.com) | Buddhanagar, Kathmandu | Instant Home Delivery Service in Nepal
- [NITV Streamz Pvt. Ltd.](https://nettv.com.np/) | Ekantakuna, Lalitpur | TV streaming
- [Numeric Mind](https://numericmind.com) | Bhatbhateni, Kathmandu | Statistical service company that provides insightful statistical solutions and data analytical services to enterprises and research firms seeking to make informed business decisions
- [Okhati Solutions](https://www.okhati.com.np/) | Bagbazar, Kathmandu | Dedicated to create suitable environment for doctors, patients and other health service providers to work together
- [Outcode Software](https://outcodesoftware.com/) | Naxal, Kathmandu | Outcode is a product-focused technology services company driven by a vision to create successful products using our expertise in Product, Design, Engineering, Quality and Consulting
- [Outsource Array](https://outsourcearray.com/) | Thamel, Kathmandu | Design, Development, Maintenance and Support all in one place

## P - R

- [PageVamp](https://www.pagevamp.com/) | Sanepa, Lalitpur | Create and Update Website from Facebook Page
- [Parewa Labs Pvt. Ltd.](https://parewalabs.com/) | Jhamsikhel, Lalitpur | Products for programming enthusiasts and learners like Programiz.com and Programiz PRO
- [Pathway Technologies and Services](https://pathway.com.np/) | Thapathali, Kathmandu | Solutions and services in the field of software development, business/knowledge process outsourcing as well as consultancy and advisory services on information and communication technologies
- [Peace Nepal DOT Com P. Ltd.](https://peacenepal.com.np/) | Kupondole, Lalitpur | Website and Software Development, SEO, Web Hosting, Web Graphic and Logo Design
- [Perfect Active Solutions Pvt. Ltd.](https://pas.com.np/) | Old Baneshwor, Kathmandu | Website and Software Development for organizations operating in Nepal
- [Pioneer Solutions](https://www.pioneersolutionsglobal.com/) | Sitapaila Chowk, Kathmandu | Next Generation C/ETRM and EMIS Software
- [Professional Computer System Pvt. Ltd.](https://www.pcs.com.np/) | Chakupat, Lalitpur | We develop national or enterprise-wide application for Government, Banking & Financial Sectors and Manufacturing Industries Verticals
- [Progressive Labs Pvt. Ltd.](https://progressivelabs.tech/) | Baneshwor, Kathmandu | Web and mobile app development
- [Proshore](https://proshore.nl/) | Tinkune, Kathmandu | New media solutions that enable you to achieve your goal
- [QPay](https://www.qpay.com.np/) | Baluwatar, Kathmandu | Mobile based payment solution
- [Rara Labs](https://www.raralabs.com/) | Manbhawan, Lalitpur | We serve global customers by developing deep technology software products with specialization on Automation, Digitization, Distribution, and Data Governance
- [Renegade Insurance](https://renegadeinsurance.com/) | Ekantakuna, Lalitpur | A technology-driven insurance brokerage in the US market that combines cutting-edge tech and modern consumerism with an old-fashioned human touch
- [Ribera Solutions](https://www.riberasolutions.com/) | Pulchowk, Lalitpur | Our Expertise – Internet of Things (IoT)
- [Rigo Technology](https://www.rigonepal.com/) | Lazimpat, Kathmandu | Rigo provides Information Technology Consultancy, System Design and Payroll Outsourcing Service
- [Rooster Logic Pvt. Ltd.](https://roosterlogic.com/) | Gairidhara, Kathmandu | Data solutions, Web and mobile app development
- [Rosebay Consulting Pvt. Ltd.](https://rosebayconsult.com/) | Baluwatar, Kathmandu | Blockchain, Product Development, Data Solutions
- [Rumsan](https://rumsan.com/) | Kupondole, Lalitpur | Revolutionize the potential of blockchain technology, reshaping its role to contribute to a positive and sustainable future

## S - U

- [Sajilo Saathi](https://sajilosaathi.com/) | Sankhamul, Kathmandu | Ride sharing app
- [Sastodeal - Be Genuine](https://www.sastodeal.com/) | Tripureshwor, Kathmandu | Provide e-commerce services for businesses to connect to it's customers online
- [Sastra Creations Pvt. Ltd.](https://sastracreations.com/) | Baluwatar, Kathmandu | Web Hosting Solutions, Web Development, Software Solutions, Logo Design & Branding
- [SecurityPal](https://www.securitypalhq.com/) | Baluwatar, Kathmandu | SecurityPal, a fast-growing early-stage startup based out of San Francisco, is on a mission to power growth through security
- [Seknox Cybersecurity](https://seknox.com) | Jhamsikhel, Lalitpur | We help achieving secure access to internal servers and services using our product TRASA
- [Semantic Creation](https://www.semanticcreation.com/) | Pulchowk, Lalitpur | Provide professional services covering all areas of modern technology
- [Shiran Techlonogies Pvt. Ltd.](https://www.shirantech.com/) | Hattisar, Kathmandu | Mobile App Development, Mobile Application Marketing, Mobile Marketing Consultation & Web Application Development
- [Smartmobe Solutions](https://smartmobe.com/) | Tripureshwor, Kathmandu | Mobile Apps, Graphic Design, and Web Development Services
- [Sofsee Tech](https://sofsee.com) | Mahendranagar, Kanchanpur | A full-service IT Company that provides solutions to grow businesses with development tools, technology and digital marketing strategies
- [Softbenz Infosys](https://softbenz.com/) | Shankhamul, Kathmandu | Provide service on website design and software development along with mobile app development, digital marketing and graphics designing
- [Softhover](https://www.softhover.com/) | Bansbari Rd, Kathmandu | Mobile Apps and Web Development Services
- [Sofwena Pvt. Ltd.](https://sofwena.com/) | Patan Dhoka, Lalitpur | Sofwena is a company providing software development and product delivery services to Business House Holds, Agriculture Industry and Financial Management
- [Source Code Pvt. Ltd.](https://www.sourcecode.com.np/) | Durbar Marg, Kathmandu | Financial technology company established with the aim of simplifying technology for capital markets
- [SoAni Tech Pvt. Ltd.](https://www.soanitech.com) | Manbhawan, Lalitpur | Create a space for digitalization and simplify complexity through software
- [Spark Tech](https://spark.com.np/) | Tinkune, Kathmandu | Tech agency that creates innovative and meaningful digital products
- [SPI Nepal](https://www.softvision.com/) | Thapathali, Kathmandu | Provider of Digital Solutions, Mobility, Analytics, Merchandise Planning, In-Store Engagements and Quality Assurance
- [SUBISU CABLENET Pvt. Ltd.](https://subisu.net.np/) | Jhamsikhel, Lalitpur | Internet, Network and Television Service Provider
- [SUNAI Technology Pvt. Ltd.](https://sunai.xyz/) | Gairidhara, Kathmandu | Custom software development outsourcing company for platform-based solutions specialized in cloud/devops, mobile/web app development & product design
- [Supreme IT Solutions Pvt. Ltd.](https://supremeit.net/) | New Baneshwor, Kathmandu | We transform Business through Technology
- [Sursa Tech Pvt. Ltd.](https://www.sursatech.com/) | Maharajgunj, Kathmandu | IT service provider with a major focus on software development, quality analysis and mobile development projects
- [Susankya Tech Pvt. Ltd.](https://susankya.com/) | Kupondole, Lalitpur | Software company with highly experienced and like-minded experts focusing on real-world problems, implementing the best solutions to simplify day-to-day life
- [Sustainable Solutions](https://sussol.net/) | Pulchowk, Lalitpur | mSupply and MoneyWorks
- [Swift Technology](https://www.swifttech.com.np/) | Panipokhari, Kathmandu | Leading FinTech company established in 2007, expertise in digital financial services, Mobile Banking, Internet Banking, Remittance System, Mobile wallet and customized software development
- [Tech Bizz Pvt. Ltd.](https://www.techbizznepal.com/) | Maitidevi, Kathmandu | Mobile Apps, Graphics Design, and Web Development Services
- [Tech Kraft Inc.](https://techkraftinc.com/) | Kupondole, Lalitpur | Outsourcing company known for Technology Consulting, Software Development, Product Design, and Training
- [Tech Kunja Pvt. Ltd.](https://techkunja.com.np/) | Patan, Lalitpur | Web design, web development, AI, graphics design and consulting services
- [Tech One Global Pvt. Ltd.](https://www.techoneglobal.com/) | Naxal, Kathmandu | Technology solutions to maximize your ROI and secure your organization
- [Techie IT Pvt. Ltd.](https://www.techie.com.np) | Mid Baneshwor, Kathmandu | Web Application Development, eCommerce Development, App Development and Digital Marketing
- [Tech101](https://www.tech101.com.np/) | Kamaladi, Kathmandu | Web design, web development, graphics design and digital marketing
- [TechNepal](https://technepal.io) | Nakhipot, Lalitpur | One stop tech news portal in Nepal
- [Technorio](https://technorio.com) | Sankhamul, Kathamandu | Web & Application Development, Digital Marketing, Corporate IT Services and Solution
- [Techno Troop Inc. Pvt. Ltd.](https://www.technotroop.com/) | Putalisadak, Kathmandu | Mobile Apps, Graphics Design, and Web Development Services
- [The Next Coders](https://thenextcoders.com/) | Birendrangar, Surkhet | Nepal's Top Web & Mobile App Developers
- [ThemeGrill](https://themegrill.com/) | Basundhara, Kathmandu | Free and Premium WordPress Themes Store
- [Three Monks](https://www.threemonk.com/) | New Baneshwor, Kathmandu | Carter the growing needs in the space of technical expertise with special focus on Digital Financial Services, Money Transfer Business and Entertainment Companies
- [Truemark](https://truemark.dev) | Ranibari Chowk, Kathmandu | We are remote first, quality focused outsourcing company
- [UBA Solutions](https://www.uba-solutions.com/) | Thadodhunga, Lalitpur | Software Research and Development
- [Umanga Creation Pvt. Ltd.](https://umangacreation.com.np/) | Uttar Dhoka, Kathmandu | We innovate/create/implement brands to realise their true potential
- [Unelma Platforms](https://unelmaplatforms.com/) | Ratnanagar, Chitwan | Provider of software development services for higher-education, healthcare and business markets
- [UniAxilSoftwares](https://uniaxialsoftwares.com/) | Anamnagar, Kathmandu | Innovation - for real world problems
- [Unifun](https://unifun.com/) | Nagpokhari, Kathmandu | Unifun is a provider of high-class IT products for Mobile Operators
- [Unlimited Technology Pvt. Ltd.](https://unlimit.com) | Khichapokhari, Kathmandu | Expertise in business software, custom software, business intelligence, document management/collaboration, mobile and infrastructure solutions
- [UXCam](https://uxcam.com/) | Thapathali, Kathmandu | A self-service mobile app analytics platform that captures user behavior and provides actionable insights for product teams

## V - X

- [Vairav Technology](https://vairav.net/) | Baluwatar, Kathmandu | Cybersecurity agency which follows global standards and framework in technology, audit and security, adopting them to suit the client's need and urgency without compromising the essence of their companies
- [Verisk Nepal](https://verisknepal.com.np/) | Hattisar, Kathmandu | Software development and information technology (IT) service support center for Verisk Analytics
- [Vianet Communications Pvt. Ltd.](https://www.vianet.com.np/) | Jawalakhel, Lalitpur | Provider of high speed Internet connectivity and communications solutions for business and individuals
- [View Nepal](https://www.viewnepal.com/) | Kamalpokhari, Kathmandu | Web and Logo Design, Web Hosting, Domain Registration
- [Visualise VR](https://visualisevr.com/) | Pulchowk, Lalitpur | Help business benefit from mixed reality technologies
- [Viveka Health](https://www.vivekahealth.com/) | Sanepa, Lalitpur | Software company working on health data projects
- [Vurilo Nepal Pvt. Ltd.](https://www.vurilo.com/) | Maharajgunj, Kathmandu | Best e-learning platform in Nepal, make quality education accessible to as many people as possible
- [Walkers Hive Pvt. Ltd.](https://walkershive.com/) | Putalisadak, Kathmandu | Digital Marketing, Optimized Website, Management System, Mobile Applications, Software Integration, Advanced Level Programming Course, IT Consultation
- [Waterflow Technology](https://waterflow.technology/) | Durbar Marg, Kathmandu | Prioritize innovative solutions for clients transitioning from legacy software to modern practices
- [Webpage Nepal Pvt. Ltd.](https://webpagenepal.com/) | New Road, Pokhara | Pokhara based web development company
- [WebRobo](https://www.web-robo.com/) | Setopul, Kathmandu | Creative website development and digital marketing
- [Wiseyak Inc.](https://wiseyak.com) | Bhatbhateni, Kathmandu | We offer unique solutions around clinical decision support across the healthcare industry in a unified platform using Artificial Intelligence and Machine Learning
- [Wesionary Team](https://wesionary.team) | Balkumari, Lalitpur | Beyond Feature Development Towards Business Co-Creation
- [Webpoint Solutions, LLC](https://www.webpoint.io/) | Sanepa, Lalitpur | Web Development and Digital Marketing Agency
- [WebSoft Nepal Pvt. Ltd.](https://www.websoftnepal.com) | Indradev Marg, Narayangarh | Provides a complete solution on Web Design and Hostings
- [Worldlink Communications Pvt. Ltd.](https://worldlink.com.np/) | Jawalakhel, Lalitpur | Complete IT service provider providing services such as data connectivity, network integration and consulting, web hosting, hardware sales and maintenance

## Y - \#

- [YAJ Tech Pvt. Ltd.](https://yajtechnologies.com/) | Kamaladi, Kathmandu | Innovative software development, web design & web hosting company aimed at making people, their lives and business better and smarter
- [Yarsa Labs](https://yarsa.io/) | Zero Kilometer, Pokhara | Building and distributing high quality software applications for mobile and the web
- [Yellow Nepal Pvt. Ltd. (Fawesome Apps)](https://fawesomeapps.com/) | Putalisadak, Kathmandu | We provide companies with senior tech talents and product development expertise to build world-class software
- [Yomari Information Services Incorporated](https://yomari.com/) | Kumaripati, Lalitpur | Analytics, business intelligence (BI), and data warehouse consultants
- [YoungInnovations](https://younginnovations.com.np/) | Kumaripati, Lalitpur | We create innovative and powerful solutions to global development problems
- [Young Minds Creation Pvt. Ltd.](https://www.youngminds.com.np/) | Shantinagar, Kathmandu | We are Software Development & Website Design Company
- [Zegal Nepal Pvt. Ltd.](https://zegal.com/) | Jawalakhel, Lalitpur | Zegal is the premier end-to-end platform for legal contract management and automation
- [ZurelSoft](https://www.zurelsoft.com/) | Jawalakhel, Lalitpur | Data-driven lean construction software solutions
- [Zyoba Labs](https://www.zyobalabs.com/) | Patan Dhoka, Lalitpur | Translating business requirement to meaningful technology solutions is what we strive for

---

## Additional Resources

- [Machine Learning Companies in Nepal](https://github.com/amitness/ml-companies-in-nepal)

## License

[MIT](LICENSE)

---

**List format inspired from [hiring-without-whiteboards](https://github.com/poteto/hiring-without-whiteboards).**
