/**
 * Generated by orval v7.3.0 🍺
 * Do not edit manually.
 * Medusa API
 * OpenAPI spec version: 1.0.0
 */
import type { StoreCartAddress } from './storeCartAddress';
import type { StoreCartLineItem } from './storeCartLineItem';
import type { StoreCartMetadata } from './storeCartMetadata';
import type { StorePaymentCollection } from './storePaymentCollection';
import type { StoreRegion } from './storeRegion';
import type { StoreCartShippingMethod } from './storeCartShippingMethod';

/**
 * The cart's details.
 */
export interface StoreCart {
  billing_address?: StoreCartAddress;
  /** The date the cart was created. */
  created_at?: string;
  /** The cart's currency code. */
  currency_code: string;
  /** The ID of the customer the cart belongs to. */
  customer_id?: string;
  /** The tax total applied on the discounted amount. */
  discount_tax_total: number;
  /** The cart's discount total. */
  discount_total: number;
  /** The email of the customer the cart belongs to. */
  email?: string;
  /** The total taxes applied on the gift card amount. */
  gift_card_tax_total: number;
  /** The total gift card amount applied on the cart. */
  gift_card_total: number;
  /** The cart's ID. */
  id: string;
  /** The cart items' total excluding taxes, including promotions. */
  item_subtotal: number;
  /** The cart items' tax total including promotions. */
  item_tax_total: number;
  /** The cart items' total including taxes and promotions. */
  item_total: number;
  /** The cart's items. */
  items?: StoreCartLineItem[];
  /** The cart's metadata, can hold custom key-value pairs. */
  metadata?: StoreCartMetadata;
  /** The cart items' total excluding taxes, including promotions. */
  original_item_subtotal: number;
  /** The cart items' tax total excluding promotions. */
  original_item_tax_total: number;
  /** The cart items' total including taxes, excluding promotions. */
  original_item_total: number;
  /** The cart's shipping total excluding taxes, including promotions. */
  original_shipping_subtotal: number;
  /** The total taxes applied on the cart's shipping amount. */
  original_shipping_tax_total: number;
  /** The cart's shipping total including taxes, excluding promotions. */
  original_shipping_total: number;
  /** The cart's total excluding taxes, including promotions. */
  original_subtotal: number;
  /** The cart's tax total excluding promotions. */
  original_tax_total: number;
  /** The cart's total including taxes, excluding promotions. */
  original_total: number;
  payment_collection?: StorePaymentCollection;
  region?: StoreRegion;
  /** The ID of the region the cart belongs to. */
  region_id?: string;
  /** The ID of the cart's sales channel. Only products that belong to the same sales channel can be added to the cart. The created order will be associated with the same sales channel. */
  sales_channel_id?: string;
  shipping_address?: StoreCartAddress;
  /** The cart's shipping methods. */
  shipping_methods?: StoreCartShippingMethod[];
  /** The cart's shipping total excluding taxes, including promotions. */
  shipping_subtotal: number;
  /** The total taxes applied on the cart's shipping amount. */
  shipping_tax_total: number;
  /** The cart's shipping total including taxes and promotions. */
  shipping_total: number;
  /** The cart's total excluding taxes, including promotions. */
  subtotal: number;
  /** The cart's tax total including promotions. */
  tax_total: number;
  /** The cart's total including taxes and promotions. */
  total: number;
  /** The date the cart was updated. */
  updated_at?: string;
}
