/**
 * Generated by orval v7.3.0 🍺
 * Do not edit manually.
 * Medusa API
 * OpenAPI spec version: 1.0.0
 */
import type { BaseExchangeItem } from './baseExchangeItem';
import type { OrderExchangeMetadata } from './orderExchangeMetadata';
import type { Order } from './order';
import type { OrderExchangeRawDifferenceDue } from './orderExchangeRawDifferenceDue';
import type { Return } from './return';
import type { OrderShippingMethod } from './orderShippingMethod';
import type { OrderTransaction } from './orderTransaction';

/**
 * The order change's exchange.
 */
export interface OrderExchange {
  /** The new items (outbound) sent by the exchange. */
  additional_items: BaseExchangeItem[];
  /** Whether variants that are out of stock can be added to the exchange as outbound items. */
  allow_backorder?: boolean;
  /** The date the exchange was canceled. */
  canceled_at?: string;
  /** The date that the exchange was created. */
  created_at?: string;
  /** The ID of the user that created the exchange. */
  created_by?: string;
  /** The date the exchange was deleted. */
  deleted_at?: string;
  /** The amount to be exchanged or refunded. If the amount is negative, it must be refunded. If positive, additional payment is required from the customer. */
  difference_due?: number;
  /** The exchange's display ID. */
  display_id: number;
  /** The exchange's ID. */
  id: string;
  /** The exchange's metadata, can hold custom key-value pairs. */
  metadata: OrderExchangeMetadata;
  /** Whether to send the customer notifications when the exchange is updated. */
  no_notification?: boolean;
  order?: Order;
  /** The ID of the order the exchange is created for. */
  order_id: string;
  /** The version of the order when the exchange is applied. */
  order_version: number;
  raw_difference_due?: OrderExchangeRawDifferenceDue;
  return?: Return;
  /** The ID of the associated exchange. */
  return_id?: string;
  /** The shipping methods used to send the new (outbound) items. */
  shipping_methods?: OrderShippingMethod[];
  /** The exchange's transactions. */
  transactions?: OrderTransaction[];
  /** The date that the exchange was updated. */
  updated_at?: string;
}
