/**
 * Generated by orval v7.3.0 🍺
 * Do not edit manually.
 * Medusa API
 * OpenAPI spec version: 1.0.0
 */
import type { AdminOrderAddress } from './adminOrderAddress';
import type { AdminCustomer } from './adminCustomer';
import type { AdminOrderFulfillmentStatus } from './adminOrderFulfillmentStatus';
import type { AdminOrderFulfillment } from './adminOrderFulfillment';
import type { AdminOrderLineItem } from './adminOrderLineItem';
import type { AdminOrderMetadata } from './adminOrderMetadata';
import type { AdminPaymentCollection } from './adminPaymentCollection';
import type { AdminOrderPaymentStatus } from './adminOrderPaymentStatus';
import type { AdminSalesChannel } from './adminSalesChannel';
import type { AdminOrderShippingMethod } from './adminOrderShippingMethod';
import type { BaseOrderSummary } from './baseOrderSummary';
import type { BaseOrderTransaction } from './baseOrderTransaction';

/**
 * The order's details.
 */
export interface AdminOrder {
  billing_address?: AdminOrderAddress;
  /** The date the order was created. */
  created_at: string;
  /** The order's currency code. */
  currency_code: string;
  customer?: AdminCustomer;
  /** The ID of the customer that placed the order. */
  customer_id: string;
  /** The tax total of order's discount or promotion. */
  discount_tax_total: number;
  /** The order's discount or promotions total. */
  discount_total: number;
  /** The order's display ID. */
  display_id?: number;
  /** The email of the customer that placed the order. */
  email: string;
  /** The order's fulfillment status. */
  fulfillment_status: AdminOrderFulfillmentStatus;
  /** The order's fulfillments. */
  fulfillments?: AdminOrderFulfillment[];
  /** The tax total of the order's gift card. */
  gift_card_tax_total: number;
  /** The order's gift card total. */
  gift_card_total: number;
  /** The order's ID. */
  id: string;
  /** The total of the order's items excluding taxes, including promotions. */
  item_subtotal: number;
  /** The tax total of the order's items including promotions. */
  item_tax_total: number;
  /** The total of the order's items including taxes and promotions. */
  item_total: number;
  /** The order's items. */
  items: AdminOrderLineItem[];
  /** The order's metadata, can hold custom key-value pairs. */
  metadata?: AdminOrderMetadata;
  /** The total of the order's items excluding taxes, including promotions. */
  original_item_subtotal: number;
  /** The tax total of the order's items excluding promotions. */
  original_item_tax_total: number;
  /** The total of the order's items including taxes, excluding promotions. */
  original_item_total: number;
  /** The order's shipping total excluding taxes, including promotions. */
  original_shipping_subtotal: number;
  /** The tax total of the order's shipping excluding promotions. */
  original_shipping_tax_total: number;
  /** The order's shipping total including taxes, excluding promotions. */
  original_shipping_total: number;
  /** The order's total excluding taxes, including promotions. */
  original_subtotal: number;
  /** The order's tax total, excluding promotions. */
  original_tax_total: number;
  /** The order's total excluding promotions, including taxes. */
  original_total: number;
  /** The order's payment collections. */
  payment_collections: AdminPaymentCollection[];
  /** The order's payment status. */
  payment_status: AdminOrderPaymentStatus;
  /** The ID of the region associated with the order. */
  region_id: string;
  sales_channel?: AdminSalesChannel;
  /** The ID of the sales channel the order is placed in. */
  sales_channel_id: string;
  shipping_address?: AdminOrderAddress;
  /** The order's shipping methods. */
  shipping_methods: AdminOrderShippingMethod[];
  /** The order's shipping total excluding taxes, including promotions. */
  shipping_subtotal: number;
  /** The tax total of the order's shipping. */
  shipping_tax_total: number;
  /** The order's shipping total including taxes and promotions. */
  shipping_total: number;
  /** The order's total excluding taxes, including promotions. */
  subtotal: number;
  summary: BaseOrderSummary;
  /** The order's tax total including promotions. */
  tax_total: number;
  /** The order's total including taxes and promotions. */
  total: number;
  /** The order's transactions. */
  transactions?: BaseOrderTransaction[];
  /** The date the order was updated. */
  updated_at: string;
  /** The order's version. */
  version: number;
}
