# DemoGPT 开发路线图

我们的目标是使 DemoGPT 能够完成通过 LangChain 可以完成的任何事情。为了实现这一目标，我们已经概述了以下开发路线图：

## 第一阶段：新 DemoGPT 流程实现

- 实现新的 DemoGPT 流程，包括计划生成、任务创建、代码片段生成和最终代码组装。
- 定义有用的 LangChain 任务，并发布新流程的版本，无需精炼。

## 第二阶段：模型选择和集成

- 添加一个功能，允许用户选择满足特定性能标准的模型。
- 将 Llama 2 集成到 DemoGPT 中，以便在本地运行所有内容。

## 第三阶段：任务实现和精炼

- 实现剩余的 LangChain 任务。
- 实现模型响应精炼的自我精炼策略。

## 第四阶段：API 集成和扩展

- 集成 Gorilla 模型进行 API 调用。
- 添加 Rapid API 以扩展可用的 API 调用。

## 第五阶段：数据库实现

- 实现公共可用的数据库，通过在精炼过程中检索类似的示例来加速生成过程。
- 将所有成功生成的步骤添加到 DB 中，以消除冗余的精炼。

## 第六阶段：创建基于 React 的应用程序

- 扩展 DemoGPT 的功能，以创建基于 React 的应用程序，利用自我精炼策略不断提高应用程序性能。

此路线图将指导我们的开发工作，我们期待着与社区分享我们的进展，努力使 DemoGPT 成为 LangChain 开发的不可或缺的工具。
