# 训练尺寸说明
YOLOv6支持三种训练尺寸模式。

## 1. 正方形尺寸训练
如果只给 `--img-size` 指定一个数字，例如 `--img-size 640`，则图像的长边将被缩放到 640（保持长宽比），短边等比例缩放后，将被填充到 640。送入模型的图像的分辨率将变为（640, 640, 3）。

## 2. 矩形尺寸训练
如果传递了 `--img-size 640` 和 `--rect`，则图像的长边将被缩放到 640（保持长宽比），短边将被等比例缩放，然后填充到 32 的倍数（如果需要）。
例如，如果一张图像的形状为（720, 1280, 3），在等比例缩放后，它的形状将变为（360, 640, 3），但是 360 不是 32 的倍数，因此它将被填充为（384, 640, 3）。

## 3. 特定尺寸
在矩形尺寸训练模式下，训练过程可能有不同的训练尺寸，例如（1080, 1920, 3）和（1200, 1600, 3）。如果您想指定一个尺寸，可以使用 `--specific-shape` 命令，并使用 `--height` 和 `--width` 指定您的训练尺寸，例如：
```
python tools/train.py --data data/dataset.yaml --conf configs/yolov6n.py --specific-shape --width 1920 --height 1080
```
那么，无论数据集中图片的形状是什么，训练数据的分辨率将都是 (1080, 1920, 3)。
