"use client";

import React from "react";
import { PlusIcon } from "lucide-react";
import { Button } from "@/components/dynamic-core/button";
import { NumberField } from "@/components/dynamic-core/number-field";
import { Tooltip } from "@/components/dynamic-core/tooltip";

export default function Demo() {
  const [offset, setOffset] = React.useState(10);
  return (
    <div className="flex flex-col items-center gap-10">
      <Tooltip offset={offset} content="Add to library">
        <Button shape="square">
          <PlusIcon />
        </Button>
      </Tooltip>
      <NumberField
        label="Offset"
        value={offset}
        onChange={(value) => setOffset(value)}
        className="max-w-[150px]"
      />
    </div>
  );
}
