"use client";

import React from "react";
import { CalendarIcon } from "lucide-react";
import { Button } from "@/components/dynamic-core/button";
import { Calendar } from "@/components/dynamic-core/calendar";
import { DateInput, DateSegment } from "@/components/dynamic-core/date-input";
import { DatePickerRoot } from "@/components/dynamic-core/date-picker";
import { DialogContent } from "@/components/dynamic-core/dialog";
import {
  Description,
  FieldError,
  Label,
} from "@/components/dynamic-core/field";
import { InputRoot } from "@/components/dynamic-core/input";
import { Overlay } from "@/components/dynamic-core/overlay";

export default function Demo() {
  return (
    <DatePickerRoot>
      <Label>Meeting date</Label>
      <InputRoot
        suffix={
          <Button variant="default" size="sm" shape="square" className="size-7">
            <CalendarIcon />
          </Button>
        }
        className="pr-1"
      >
        <DateInput>{(segment) => <DateSegment segment={segment} />}</DateInput>
      </InputRoot>
      <Description>Please select a date.</Description>
      <FieldError />
      <Overlay type="popover" mobileType="drawer">
        <DialogContent>
          <Calendar />
        </DialogContent>
      </Overlay>
    </DatePickerRoot>
  );
}
