import { existsSync, promises as fs } from "node:fs";
import path from "path";
import { rimraf } from "rimraf";
import { demos } from "@/registry/demos";

async function buildDemos() {
  let index = `// This file is autogenerated by scripts/build-registry.ts
  // Do not edit this file directly.
  import * as React from "react"
  
  export const Index: Record<string, any> = {
  `;

  // core demos
  index += `  core: {`;

  for (const item of demos) {
    const demoPath = item.files[0];

    index += `
    "${item.name}": {
      name: "${item.name}",
      files: ["${demoPath}"],
      component: React.lazy(() => import("@/${demoPath.replace(".tsx", "")}")),
    },`;
  }

  index += `
  },`;

  index += `
}
`;

  const targetPath = path.join(process.cwd(), "src", "__demos__");
  if (!existsSync(targetPath)) {
    await fs.mkdir(targetPath, { recursive: true });
  }
  rimraf.sync(path.join(targetPath, "index.tsx"));
  await fs.writeFile(path.join(targetPath, "index.tsx"), index, "utf8");
}

buildDemos();
