# Contributing to dotUI

Contributions are what makes the open source community such an amazing place to learn, inspire, and create. Your contributions to this project are not just welcome, but deeply valued. We sincerely appreciate every effort you make to improve and enhance dotUI.

Please take a moment to review this document before starting your contribution.

## How to contribute

### Prerequisites

In order to not waste your time implementing a change that has already been declined, or is generally not needed, start by [opening an issue](https://github.com/mehdibha/dotUI/issues/new/choose) describing the problem you would like to solve.

This project uses [pnpm](https://pnpm.io) as its package manager. Install it if you haven't already:

```bash
npm install -g pnpm
```

### Setup your environment locally

In order to contribute to this project, you will need to:

1. Fork the repository
   You can do it by clicking the fork button in the top right corner of this page.

2. Clone the repository on your local machine

```bash
git clone https://github.com/your-username/dotui.git
```

3. Create a new Branch

```bash
git checkout -b my-new-branch
```

4. Install the dependencies

```bash
pnpm install
```

### Implement your changes

This project is a [Turborepo](https://turborepo.org/) monorepo. The code for the CLI is in the `packages/cli` directory, and the docs is in the `www` directory. Now you're all setup and can start implementing your changes.

Here are some useful scripts for when you are developing:

| Command          | Description                                             |
| ---------------- | ------------------------------------------------------- |
| `pnpm dev:www`   | Starts the development server for the docs website     |
| `pnpm dev:cli`   | Builds and starts the CLI in watch-mode                 |
| `pnpm build:cli` | Builds the CLI                                          |
| `pnpm build:www` | Builds the docs                                         |
| `pnpm build`     | Builds CLI and docs                                     |
| `pnpm format`    | Formats the code                                        |
| `pnpm lint`      | Lints the code                                          |
| `pnpm lint:fix`  | Lints the code and fixes any errors                     |
| `pnpm check`     | Checks your code for typeerrors, formatting and linting |

When making commits, make sure to follow the [conventional commit](https://www.conventionalcommits.org/en/v1.0.0/) guidelines, i.e. prepending the message with `feat:`, `fix:`, `chore:`, `docs:`, etc... You can use `git status` to double check which files have not yet been staged for commit:

```bash
git add <file> && git commit -m "feat/fix/chore/docs: commit message"
```

### When you're done

Check that your code follows the project's style guidelines by running:

```bash
pnpm check
```

## Credits

This documented was inspired by the contributing guidelines for [t3-oss/create-t3-app](https://github.com/t3-oss/create-t3-app/blob/main/CONTRIBUTING.md).